/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.List;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.AbstractUdfOperator;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.util.Visitor;

public abstract class DualInputOperator<IN1, IN2, OUT, FT extends Function>
extends AbstractUdfOperator<OUT, FT> {
    protected Operator<IN1> input1;
    protected Operator<IN2> input2;
    private final int[] keyFields1;
    private final int[] keyFields2;
    private DualInputSemanticProperties semanticProperties;

    protected DualInputOperator(UserCodeWrapper<FT> stub, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name) {
        super(stub, operatorInfo, name);
        this.keyFields2 = new int[0];
        this.keyFields1 = this.keyFields2;
    }

    protected DualInputOperator(UserCodeWrapper<FT> stub, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name) {
        super(stub, operatorInfo, name);
        this.keyFields1 = keyPositions1;
        this.keyFields2 = keyPositions2;
    }

    public BinaryOperatorInformation<IN1, IN2, OUT> getOperatorInfo() {
        return (BinaryOperatorInformation)this.operatorInfo;
    }

    public Operator<IN1> getFirstInput() {
        return this.input1;
    }

    public Operator<IN2> getSecondInput() {
        return this.input2;
    }

    public void clearFirstInput() {
        this.input1 = null;
    }

    public void clearSecondInput() {
        this.input2 = null;
    }

    public void setFirstInput(Operator<IN1> input) {
        this.input1 = input;
    }

    public void setSecondInput(Operator<IN2> input) {
        this.input2 = input;
    }

    @Deprecated
    public void setFirstInput(Operator<IN1> ... inputs) {
        this.input1 = Operator.createUnionCascade(inputs);
    }

    @Deprecated
    public void setSecondInput(Operator<IN2> ... inputs) {
        this.input2 = Operator.createUnionCascade(inputs);
    }

    @Deprecated
    public void setFirstInputs(List<Operator<IN1>> inputs) {
        this.input1 = Operator.createUnionCascade(inputs);
    }

    @Deprecated
    public void setSecondInputs(List<Operator<IN2>> inputs) {
        this.input2 = Operator.createUnionCascade(inputs);
    }

    @Deprecated
    public void addFirstInput(Operator<IN1> ... input) {
        this.input1 = Operator.createUnionCascade(this.input1, input);
    }

    @Deprecated
    public void addSecondInput(Operator<IN2> ... input) {
        this.input2 = Operator.createUnionCascade(this.input2, input);
    }

    @Deprecated
    public void addFirstInputs(List<Operator<IN1>> inputs) {
        this.input1 = Operator.createUnionCascade(this.input1, inputs.toArray(new Operator[inputs.size()]));
    }

    @Deprecated
    public void addSecondInputs(List<Operator<IN2>> inputs) {
        this.input2 = Operator.createUnionCascade(this.input2, inputs.toArray(new Operator[inputs.size()]));
    }

    public DualInputSemanticProperties getSemanticProperties() {
        return this.semanticProperties;
    }

    public void setSemanticProperties(DualInputSemanticProperties semanticProperties) {
        this.semanticProperties = semanticProperties;
    }

    @Override
    public final int getNumberOfInputs() {
        return 2;
    }

    @Override
    public int[] getKeyColumns(int inputNum) {
        if (inputNum == 0) {
            return this.keyFields1;
        }
        if (inputNum == 1) {
            return this.keyFields2;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        boolean descend = visitor.preVisit(this);
        if (descend) {
            this.input1.accept(visitor);
            this.input2.accept(visitor);
            for (Operator c : this.broadcastInputs.values()) {
                c.accept(visitor);
            }
            visitor.postVisit(this);
        }
    }

    protected abstract List<OUT> executeOnCollections(List<IN1> var1, List<IN2> var2, RuntimeContext var3, boolean var4) throws Exception;
}

