/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;

public abstract class AbstractUdfOperator<OUT, FT extends Function>
extends Operator<OUT> {
    protected final UserCodeWrapper<FT> userFunction;
    protected final Map<String, Operator<?>> broadcastInputs = new HashMap();

    protected AbstractUdfOperator(UserCodeWrapper<FT> function, OperatorInformation<OUT> operatorInfo, String name) {
        super(operatorInfo, name);
        this.userFunction = function;
    }

    @Override
    public UserCodeWrapper<FT> getUserCodeWrapper() {
        return this.userFunction;
    }

    public Map<String, Operator<?>> getBroadcastInputs() {
        return this.broadcastInputs;
    }

    public void setBroadcastVariable(String name, Operator<?> root) {
        if (name == null) {
            throw new IllegalArgumentException("The broadcast input name may not be null.");
        }
        if (root == null) {
            throw new IllegalArgumentException("The broadcast input root operator may not be null.");
        }
        this.broadcastInputs.put(name, root);
    }

    public <T> void setBroadcastVariables(Map<String, Operator<T>> inputs) {
        this.broadcastInputs.clear();
        this.broadcastInputs.putAll(inputs);
    }

    public abstract int getNumberOfInputs();

    public abstract int[] getKeyColumns(int var1);

    protected static final <U> Class<U>[] asArray(Class<U> clazz) {
        Class[] array = new Class[]{clazz};
        return array;
    }

    protected static final <U> Class<U>[] emptyClassArray() {
        Class[] array = new Class[]{};
        return array;
    }
}

