/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.distributions;

import java.io.IOException;
import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.DoubleValue;

public class UniformDoubleDistribution
implements DataDistribution {
    private static final long serialVersionUID = 1L;
    private double min;
    private double max;

    public UniformDoubleDistribution() {
    }

    public UniformDoubleDistribution(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public DoubleValue[] getBucketBoundary(int bucketNum, int totalNumBuckets) {
        double bucketSize = (this.max - this.min) / (double)totalNumBuckets;
        return new DoubleValue[]{new DoubleValue(this.min + (double)(bucketNum + 1) * bucketSize)};
    }

    @Override
    public int getNumberOfFields() {
        return 1;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeDouble(this.min);
        out.writeDouble(this.max);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.min = in.readDouble();
        this.max = in.readDouble();
    }
}

