/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.distributions;

import java.io.IOException;
import org.apache.flink.api.common.distributions.SimpleDistribution;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.IntValue;

public class SimpleIntegerDistribution
extends SimpleDistribution {
    private static final long serialVersionUID = 1L;

    public SimpleIntegerDistribution() {
        this.boundaries = new IntValue[0][];
    }

    public SimpleIntegerDistribution(int[] bucketBoundaries) {
        if (bucketBoundaries == null) {
            throw new IllegalArgumentException("Bucket boundaries must not be null.");
        }
        if (bucketBoundaries.length == 0) {
            throw new IllegalArgumentException("Bucket boundaries must not be empty.");
        }
        this.dim = 1;
        this.boundaries = SimpleIntegerDistribution.packIntegers(bucketBoundaries);
    }

    public SimpleIntegerDistribution(IntValue[] bucketBoundaries) {
        if (bucketBoundaries == null) {
            throw new IllegalArgumentException("Bucket boundaries must not be null.");
        }
        if (bucketBoundaries.length == 0) {
            throw new IllegalArgumentException("Bucket boundaries must not be empty.");
        }
        this.dim = 1;
        this.boundaries = new IntValue[bucketBoundaries.length][];
        for (int i = 0; i < bucketBoundaries.length; ++i) {
            this.boundaries[i] = new IntValue[]{bucketBoundaries[i]};
        }
    }

    public SimpleIntegerDistribution(IntValue[][] bucketBoundaries) {
        if (bucketBoundaries == null) {
            throw new IllegalArgumentException("Bucket boundaries must not be null.");
        }
        if (bucketBoundaries.length == 0) {
            throw new IllegalArgumentException("Bucket boundaries must not be empty.");
        }
        this.dim = bucketBoundaries[0].length;
        for (int i = 1; i < bucketBoundaries.length; ++i) {
            if (bucketBoundaries[i].length == this.dim) continue;
            throw new IllegalArgumentException("All bucket boundaries must have the same dimensionality.");
        }
    }

    @Override
    public int getNumberOfFields() {
        return this.dim;
    }

    public IntValue[] getBucketBoundary(int bucketNum, int totalNumBuckets) {
        if (bucketNum < 0) {
            throw new IllegalArgumentException("Requested bucket must be greater than or equal to 0.");
        }
        if (bucketNum >= totalNumBuckets - 1) {
            throw new IllegalArgumentException("Request bucket must be smaller than the total number of buckets minus 1.");
        }
        if (totalNumBuckets < 1) {
            throw new IllegalArgumentException("Total number of bucket must be larger than 0.");
        }
        int maxNumBuckets = this.boundaries.length + 1;
        if (maxNumBuckets % totalNumBuckets == 0) {
            int n = maxNumBuckets / totalNumBuckets;
            int bucketId = bucketNum * n + (n - 1);
            return (IntValue[])this.boundaries[bucketId];
        }
        throw new IllegalArgumentException("Interpolation of bucket boundaries currently not supported. Please use an even divider of the maximum possible buckets (here: " + maxNumBuckets + ") as totalBuckets.");
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.dim);
        out.writeInt(this.boundaries.length);
        for (int i = 0; i < this.boundaries.length; ++i) {
            for (int d = 0; d < this.dim; ++d) {
                out.writeInt(((IntValue)this.boundaries[i][d]).getValue());
            }
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.dim = in.readInt();
        int len = in.readInt();
        this.boundaries = new IntValue[len][];
        for (int i = 0; i < len; ++i) {
            IntValue[] bucket = new IntValue[this.dim];
            for (int d = 0; d < this.dim; ++d) {
                bucket[d] = new IntValue(in.readInt());
            }
            this.boundaries[i] = bucket;
        }
    }

    private static IntValue[][] packIntegers(int[] values) {
        IntValue[][] packed = new IntValue[values.length][];
        for (int i = 0; i < values.length; ++i) {
            packed[i] = new IntValue[]{new IntValue(values[i])};
        }
        return packed;
    }
}

