/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.IOException;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class IntCounter
implements SimpleAccumulator<Integer> {
    private static final long serialVersionUID = 1L;
    private int localValue = 0;

    @Override
    public void add(Integer value) {
        this.localValue += value.intValue();
    }

    @Override
    public Integer getLocalValue() {
        return this.localValue;
    }

    @Override
    public void merge(Accumulator<Integer, Integer> other) {
        this.localValue += ((IntCounter)other).getLocalValue().intValue();
    }

    @Override
    public void resetLocal() {
        this.localValue = 0;
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.localValue);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.localValue = in.readInt();
    }

    public String toString() {
        return "IntCounter object. Local value: " + this.localValue;
    }
}

