/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class Histogram
implements Accumulator<Integer, Map<Integer, Integer>> {
    private static final long serialVersionUID = 1L;
    private Map<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();

    @Override
    public void add(Integer value) {
        Integer current = this.treeMap.get(value);
        Integer newValue = (current != null ? current : 0) + 1;
        this.treeMap.put(value, newValue);
    }

    @Override
    public Map<Integer, Integer> getLocalValue() {
        return this.treeMap;
    }

    @Override
    public void merge(Accumulator<Integer, Map<Integer, Integer>> other) {
        for (Map.Entry entryFromOther : ((Histogram)other).getLocalValue().entrySet()) {
            Integer ownValue = this.treeMap.get(entryFromOther.getKey());
            if (ownValue == null) {
                this.treeMap.put((Integer)entryFromOther.getKey(), (Integer)entryFromOther.getValue());
                continue;
            }
            this.treeMap.put((Integer)entryFromOther.getKey(), (Integer)entryFromOther.getValue() + ownValue);
        }
    }

    @Override
    public void resetLocal() {
        this.treeMap.clear();
    }

    public String toString() {
        return this.treeMap.toString();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.treeMap.size());
        for (Map.Entry<Integer, Integer> entry : this.treeMap.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.treeMap.put(in.readInt(), in.readInt());
        }
    }
}

