/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class Plan
implements Visitable<Operator<?>> {
    private static final int DEFAULT_PARALELLISM = -1;
    protected final List<GenericDataSinkBase<?>> sinks = new ArrayList(4);
    protected String jobName;
    protected int defaultParallelism = -1;
    protected int numberOfExecutionRetries;
    protected HashMap<String, DistributedCache.DistributedCacheEntry> cacheFile = new HashMap();

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, String jobName) {
        this(sinks, jobName, -1);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, String jobName, int defaultParallelism) {
        this.sinks.addAll(sinks);
        this.jobName = jobName;
        this.defaultParallelism = defaultParallelism;
    }

    public Plan(GenericDataSinkBase<?> sink, String jobName) {
        this(sink, jobName, -1);
    }

    public Plan(GenericDataSinkBase<?> sink, String jobName, int defaultParallelism) {
        this(Collections.singletonList(sink), jobName, defaultParallelism);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks) {
        this(sinks, -1);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, int defaultParallelism) {
        this(sinks, "Flink Job at " + Calendar.getInstance().getTime(), defaultParallelism);
    }

    public Plan(GenericDataSinkBase<?> sink) {
        this(sink, -1);
    }

    public Plan(GenericDataSinkBase<?> sink, int defaultParallelism) {
        this(sink, "Flink Job at " + Calendar.getInstance().getTime(), defaultParallelism);
    }

    public void addDataSink(GenericDataSinkBase<?> sink) {
        Preconditions.checkNotNull((Object)this.jobName, (Object)"The data sink must not be null.");
        if (!this.sinks.contains(sink)) {
            this.sinks.add(sink);
        }
    }

    public Collection<? extends GenericDataSinkBase<?>> getDataSinks() {
        return this.sinks;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        Preconditions.checkNotNull((Object)jobName, (Object)"The job name must not be null.");
        this.jobName = jobName;
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public void setDefaultParallelism(int defaultParallelism) {
        Preconditions.checkArgument((defaultParallelism >= 1 || defaultParallelism == -1 ? 1 : 0) != 0, (Object)"The default degree of parallelism must be positive, or -1 if the system should use the globally comfigured default.");
        this.defaultParallelism = defaultParallelism;
    }

    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        if (numberOfExecutionRetries < -1) {
            throw new IllegalArgumentException("The number of execution retries must be non-negative, or -1 (use system default)");
        }
        this.numberOfExecutionRetries = numberOfExecutionRetries;
    }

    public int getNumberOfExecutionRetries() {
        return this.numberOfExecutionRetries;
    }

    public String getPostPassClassName() {
        return "org.apache.flink.compiler.postpass.RecordModelPostPass";
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        for (GenericDataSinkBase<?> sink : this.sinks) {
            sink.accept(visitor);
        }
    }

    public void registerCachedFile(String name, DistributedCache.DistributedCacheEntry entry) throws IOException {
        if (!this.cacheFile.containsKey(name)) {
            try {
                FileSystem fs;
                URI u = new URI(entry.filePath);
                if (!u.getPath().startsWith("/")) {
                    u = new File(entry.filePath).toURI();
                }
                if (!(fs = FileSystem.get(u)).exists(new Path(u.getPath()))) {
                    throw new IOException("File " + u.toString() + " doesn't exist.");
                }
                this.cacheFile.put(name, new DistributedCache.DistributedCacheEntry(u.toString(), entry.isExecutable));
            }
            catch (URISyntaxException ex) {
                throw new IOException("Invalid path: " + entry.filePath, ex);
            }
        } else {
            throw new IOException("cache file " + name + "already exists!");
        }
    }

    public Set<Map.Entry<String, DistributedCache.DistributedCacheEntry>> getCachedFiles() {
        return this.cacheFile.entrySet();
    }

    public int getMaximumParallelism() {
        MaxDopVisitor visitor = new MaxDopVisitor();
        this.accept(visitor);
        return Math.max(visitor.maxDop, this.defaultParallelism);
    }

    private static final class MaxDopVisitor
    implements Visitor<Operator<?>> {
        private int maxDop = -1;

        private MaxDopVisitor() {
        }

        @Override
        public boolean preVisit(Operator<?> visitable) {
            this.maxDop = Math.max(this.maxDop, visitable.getDegreeOfParallelism());
            return true;
        }

        @Override
        public void postVisit(Operator<?> visitable) {
        }
    }
}

