/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.util.Map;

public class JobExecutionResult {
    private long netRuntime;
    private Map<String, Object> accumulatorResults;

    public JobExecutionResult(long netRuntime, Map<String, Object> accumulators) {
        this.netRuntime = netRuntime;
        this.accumulatorResults = accumulators;
    }

    public long getNetRuntime() {
        return this.netRuntime;
    }

    public <T> T getAccumulatorResult(String accumulatorName) {
        return (T)this.accumulatorResults.get(accumulatorName);
    }

    public Map<String, Object> getAllAccumulatorResults() {
        return this.accumulatorResults;
    }

    public Integer getIntCounterResult(String accumulatorName) {
        Object result = this.accumulatorResults.get(accumulatorName);
        if (result == null) {
            return null;
        }
        if (!(result instanceof Integer)) {
            throw new ClassCastException("Requested result of the accumulator '" + accumulatorName + "' should be Integer but has type " + result.getClass());
        }
        return (Integer)result;
    }
}

