/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.Serializable;

public class ExecutionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONFIG_KEY = "runtime.config";
    private boolean useClosureCleaner = true;
    private int degreeOfParallelism = -1;
    private int numberOfExecutionRetries = -1;

    public ExecutionConfig enableClosureCleaner() {
        this.useClosureCleaner = true;
        return this;
    }

    public ExecutionConfig disableClosureCleaner() {
        this.useClosureCleaner = false;
        return this;
    }

    public boolean isClosureCleanerEnabled() {
        return this.useClosureCleaner;
    }

    public int getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public ExecutionConfig setDegreeOfParallelism(int degreeOfParallelism) {
        if (degreeOfParallelism < 1) {
            throw new IllegalArgumentException("Degree of parallelism must be at least one.");
        }
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    public int getNumberOfExecutionRetries() {
        return this.numberOfExecutionRetries;
    }

    public ExecutionConfig setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        if (numberOfExecutionRetries < -1) {
            throw new IllegalArgumentException("The number of execution retries must be non-negative, or -1 (use system default)");
        }
        this.numberOfExecutionRetries = numberOfExecutionRetries;
        return this;
    }
}

