/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TaskReport
implements Writable {
    private TaskID taskid;
    private float progress;
    private String state;
    private String[] diagnostics;
    private long startTime;
    private long finishTime;
    private Counters counters;
    private TIPStatus currentStatus;
    private Collection<TaskAttemptID> runningAttempts = new ArrayList<TaskAttemptID>();
    private TaskAttemptID successfulAttempt = new TaskAttemptID();

    public TaskReport() {
        this.taskid = new TaskID();
    }

    public TaskReport(TaskID taskid, float progress, String state, String[] diagnostics, TIPStatus currentStatus, long startTime, long finishTime, Counters counters) {
        this.taskid = taskid;
        this.progress = progress;
        this.state = state;
        this.diagnostics = diagnostics;
        this.currentStatus = currentStatus;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.counters = counters;
    }

    public TaskID getTaskId() {
        return this.taskid;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getState() {
        return this.state;
    }

    public String[] getDiagnostics() {
        return this.diagnostics;
    }

    public Counters getTaskCounters() {
        return this.counters;
    }

    public TIPStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    protected void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected void setSuccessfulAttemptId(TaskAttemptID t) {
        this.successfulAttempt = t;
    }

    public TaskAttemptID getSuccessfulTaskAttemptId() {
        return this.successfulAttempt;
    }

    protected void setRunningTaskAttemptIds(Collection<TaskAttemptID> runningAttempts) {
        this.runningAttempts = runningAttempts;
    }

    public Collection<TaskAttemptID> getRunningTaskAttemptIds() {
        return this.runningAttempts;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(this.getClass())) {
            TaskReport report = (TaskReport)o;
            return this.counters.equals(report.getTaskCounters()) && Arrays.toString(this.diagnostics).equals(Arrays.toString(report.getDiagnostics())) && this.finishTime == report.getFinishTime() && this.progress == report.getProgress() && this.startTime == report.getStartTime() && this.state.equals(report.getState()) && this.taskid.equals(report.getTaskId());
        }
        return false;
    }

    public int hashCode() {
        return (this.counters.toString() + Arrays.toString(this.diagnostics) + this.finishTime + this.progress + this.startTime + this.state + this.taskid.toString()).hashCode();
    }

    public void write(DataOutput out) throws IOException {
        this.taskid.write(out);
        out.writeFloat(this.progress);
        Text.writeString((DataOutput)out, (String)this.state);
        out.writeLong(this.startTime);
        out.writeLong(this.finishTime);
        WritableUtils.writeStringArray((DataOutput)out, (String[])this.diagnostics);
        this.counters.write(out);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.currentStatus);
        if (this.currentStatus == TIPStatus.RUNNING) {
            WritableUtils.writeVInt((DataOutput)out, (int)this.runningAttempts.size());
            TaskAttemptID[] t = new TaskAttemptID[]{};
            t = this.runningAttempts.toArray(t);
            for (int i = 0; i < t.length; ++i) {
                t[i].write(out);
            }
        } else if (this.currentStatus == TIPStatus.COMPLETE) {
            this.successfulAttempt.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.taskid.readFields(in);
        this.progress = in.readFloat();
        this.state = StringInterner.weakIntern((String)Text.readString((DataInput)in));
        this.startTime = in.readLong();
        this.finishTime = in.readLong();
        this.diagnostics = WritableUtils.readStringArray((DataInput)in);
        this.counters = new Counters();
        this.counters.readFields(in);
        this.currentStatus = (TIPStatus)WritableUtils.readEnum((DataInput)in, TIPStatus.class);
        if (this.currentStatus == TIPStatus.RUNNING) {
            int num = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < num; ++i) {
                TaskAttemptID t = new TaskAttemptID();
                t.readFields(in);
                this.runningAttempts.add(t);
            }
        } else if (this.currentStatus == TIPStatus.COMPLETE) {
            this.successfulAttempt.readFields(in);
        }
    }
}

