/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import com.cenqua.clover.CoverageSnapshot;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.util.CloverBitSet;
import com_cenqua_clover.Clover;

public abstract class CoverageRecorder {
    public static final int FLUSHPOLICY_DIRECTED = 0;
    public static final int FLUSHPOLICY_INTERVAL = 1;
    public static final int FLUSHPOLICY_THREADED = 2;
    public static final long FLUSH_INTERVAL_MASK = Integer.MAX_VALUE;
    public static final int FLUSHPOLICY_MASK = 7;
    public static final int DISABLE_SHUTDOWNHOOK_MASK = 128;
    public static final int USE_CURRENT_THREADGROUP_MASK = 256;
    public static final int DISABLE_SLICE_FLUSHING_MASK = 512;

    public abstract String getDbName();

    public abstract String getRecordingName();

    public abstract long getDbVersion();

    public abstract CloverBitSet compareCoverageWith(CoverageSnapshot var1);

    public abstract CloverBitSet createEmptyHitsMask();

    public abstract void startRun();

    public abstract void flushNeeded();

    public abstract void maybeFlush();

    public abstract void forceFlush();

    public abstract void flush();

    public abstract void sliceStart(String var1, long var2, int var4, int var5);

    public abstract void sliceEnd(String var1, String var2, long var3, int var5, int var6, int var7, ErrorInfo var8);

    public abstract void inc(int var1);

    public abstract int iget(int var1);

    public abstract CoverageRecorder withCapacityFor(int var1);

    public final void rethrow(Throwable t) {
        throw t;
    }

    public final void globalSliceStart(String runtimeType, int id) {
        this.globalSliceStart(runtimeType, id, System.currentTimeMillis());
    }

    public final void globalSliceStart(String runtimeType, int id, long startTime) {
        if (Logger.isDebug()) {
            Logger.getInstance().debug("globalSliceStart(" + runtimeType + ", " + id + ", " + startTime + ")");
        }
        Clover.allRecordersSliceStart(runtimeType, id, startTime);
    }

    public void globalSliceEnd(String runtimeType, String method, int id) {
        if (Logger.isDebug()) {
            Logger.getInstance().debug("globalSliceEnd(" + runtimeType + ", " + id + ")");
        }
        Clover.allRecordersSliceEnd(runtimeType, method, id, -1, null);
    }

    public final void globalSliceEnd(String runtimeType, String method, int id, int exitStatus, Throwable throwable) {
        if (Logger.isDebug()) {
            Logger.getInstance().debug("globalSliceEnd(" + runtimeType + ", " + id + ", " + exitStatus + ", " + throwable + ")");
        }
        Clover.allRecordersSliceEnd(runtimeType, method, id, exitStatus, Clover.getErrorInfo(throwable));
    }

    public static long getConfigBits(long flushPolicy, int flushInterval, boolean useCurrentThreadGroup, boolean disableShutdownHook, boolean disableSlicedFlushing) {
        long result = flushInterval;
        result += flushPolicy << 32;
        if (disableShutdownHook) {
            result += 0x8000000000L;
        }
        if (useCurrentThreadGroup) {
            result += 0x10000000000L;
        }
        if (disableSlicedFlushing) {
            result += 0x20000000000L;
        }
        return result;
    }

    public abstract CoverageSnapshot getCoverageSnapshot();
}

