/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import com.cenqua.clover.Logger;
import com.cenqua.clover.RecorderLogging;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.SourceRegion;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RegistryDumper {
    private static int indent;
    static /* synthetic */ Class class$com$cenqua$clover$util$RegistryDumper;

    public static void main(String[] args) throws Exception {
        RecorderLogging.init();
        if (args.length != 2) {
            RegistryDumper.printUsage();
        } else {
            Clover2Registry reg = Clover2Registry.fromFile(new File(args[1]));
            if (args[0].equalsIgnoreCase("pretty")) {
                RegistryDumper.printPretty(reg, false);
            } else if (args[0].equalsIgnoreCase("prettyfull")) {
                RegistryDumper.printPretty(reg, true);
            } else if (args[0].equalsIgnoreCase("csv")) {
                RegistryDumper.printCSV(reg);
            } else {
                System.err.println("Unknown format");
            }
        }
    }

    private static void printUsage() {
        System.err.println("Usage:");
        StringBuffer stringBuffer = new StringBuffer().append("java ");
        Class<?> clazz = class$com$cenqua$clover$util$RegistryDumper;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$util$RegistryDumper = new RegistryDumper[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" pretty|csv [full] database").toString());
    }

    private static void printPretty(Clover2Registry reg, final boolean full) {
        Logger.getInstance().info("Loaded registry at " + reg.getRegistryFile());
        Logger.getInstance().info("Init String: " + reg.getInitstring());
        Logger.getInstance().info("Version: " + reg.getVersion());
        Logger.getInstance().info("Coverage Data Length: " + reg.getDataLength());
        Logger.getInstance().info("Instrumentation History:");
        Iterator i$ = reg.getInstrHistory().iterator();
        while (i$.hasNext()) {
            Object o = i$.next();
            Logger.getInstance().info(o.toString());
        }
        reg.getProject().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Logger.getInstance().info("File " + file.getPackagePath());
                indent++;
                Logger.getInstance().info(RegistryDumper.indent("Encoding: " + file.getEncoding()));
                Logger.getInstance().info(RegistryDumper.indent("Checksum: " + file.getChecksum()));
                Logger.getInstance().info(RegistryDumper.indent("File Size: " + file.getFilesize()));
                Logger.getInstance().info(RegistryDumper.indent("Line Count: " + file.getLineCount()));
                Logger.getInstance().info(RegistryDumper.indent("NC Line Count: " + file.getNcLineCount()));
                Logger.getInstance().info(RegistryDumper.indent("Timestamp: " + DateFormat.getDateTimeInstance().format(new Long(file.getTimestamp()))));
                Logger.getInstance().info(RegistryDumper.indent("Slot Index: " + ((FileInfo)file).getDataIndex()));
                Logger.getInstance().info(RegistryDumper.indent("Slot Length: " + ((FileInfo)file).getDataLength()));
                Logger.getInstance().info(RegistryDumper.indent("Class count: " + RegistryDumper.classCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Method count: " + RegistryDumper.methodCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Statement count: " + RegistryDumper.statementCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Branch count: " + RegistryDumper.branchCount((FileInfo)file)));
                Logger.getInstance().info(RegistryDumper.indent("Max version supported: " + ((FileInfo)file).getMaxVersion()));
                Logger.getInstance().info(RegistryDumper.indent("Min version supported: " + ((FileInfo)file).getMinVersion()));
                Logger.getInstance().info(RegistryDumper.indent("Classes:"));
                indent++;
                Iterator i$ = file.getClasses().iterator();
                while (i$.hasNext()) {
                    ClassInfo classInfo = (ClassInfo)i$.next();
                    Logger.getInstance().info(RegistryDumper.indent("Class " + classInfo.getQualifiedName()));
                    Logger.getInstance().info(RegistryDumper.indent("Statement count: " + RegistryDumper.statementCount(classInfo)));
                    Logger.getInstance().info(RegistryDumper.indent("Branch count: " + RegistryDumper.branchCount(classInfo)));
                    indent++;
                    MethodInfo[] arr$ = classInfo.getMethods();
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$; ++i$2) {
                        final MethodInfo methodInfo = arr$[i$2];
                        Logger.getInstance().info(RegistryDumper.indent(methodInfo.toString()));
                        if (full) {
                            indent++;
                            Logger.getInstance().info(RegistryDumper.indent(methodInfo.toString()));
                            Logger.getInstance().info(RegistryDumper.indent("Statement count: " + methodInfo.getStatements().length));
                            Logger.getInstance().info(RegistryDumper.indent("Branch count: " + methodInfo.getBranches().length));
                            ArrayList<SourceRegion> stmtsAndBranches = new ArrayList<SourceRegion>(){
                                {
                                    this.addAll(Arrays.asList(methodInfo.getBranches()));
                                    this.addAll(Arrays.asList(methodInfo.getStatements()));
                                }
                            };
                            Collections.sort(stmtsAndBranches, new Comparator<SourceRegion>(){

                                @Override
                                public int compare(SourceRegion o1, SourceRegion o2) {
                                    int startLine1 = o1.getStartLine();
                                    int startCol1 = o1.getStartColumn();
                                    int startLine2 = o2.getStartLine();
                                    int startCol2 = o2.getStartColumn();
                                    if (startLine1 < startLine2) {
                                        return -1;
                                    }
                                    if (startLine1 > startLine2) {
                                        return 1;
                                    }
                                    if (startCol1 < startCol2) {
                                        return -1;
                                    }
                                    if (startCol1 > startCol2) {
                                        return 1;
                                    }
                                    return 0;
                                }

                                @Override
                                public /* synthetic */ int compare(Object x0, Object x1) {
                                    return this.compare((SourceRegion)x0, (SourceRegion)x1);
                                }
                            });
                            indent++;
                            Iterator i$3 = stmtsAndBranches.iterator();
                            while (i$3.hasNext()) {
                                SourceRegion stmtOrBranch = (SourceRegion)i$3.next();
                                Logger.getInstance().info(RegistryDumper.indent(stmtOrBranch.toString()));
                            }
                            indent--;
                        }
                        indent--;
                    }
                    indent--;
                }
                indent--;
                indent--;
            }
        });
    }

    private static int methodCount(FileInfo fileInfo) {
        int methodCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            methodCount += ((ClassInfo)iterator.next()).getMethods().length;
        }
        return methodCount;
    }

    private static int classCount(FileInfo fileInfo) {
        return fileInfo.getClasses().size();
    }

    private static int statementCount(FileInfo fileInfo) {
        int statementCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            statementCount += RegistryDumper.statementCount(classInfo);
        }
        return statementCount;
    }

    private static int statementCount(ClassInfo classInfo) {
        int statementCount = 0;
        MethodInfo[] methods = classInfo.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            statementCount += methods[i].getStatements().length;
        }
        return statementCount;
    }

    private static int branchCount(FileInfo fileInfo) {
        int branchCount = 0;
        Iterator iterator = fileInfo.getClasses().iterator();
        while (iterator.hasNext()) {
            ClassInfo classInfo = (ClassInfo)iterator.next();
            branchCount += RegistryDumper.branchCount(classInfo);
        }
        return branchCount;
    }

    private static int branchCount(ClassInfo classInfo) {
        int branchCount = 0;
        MethodInfo[] methods = classInfo.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            branchCount += methods[i].getBranches().length;
        }
        return branchCount;
    }

    private static String indent(String line) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        return line;
    }

    public static void printCSV(Clover2Registry reg) {
        Logger.getInstance().info("Init String,Version,Coverage Data Length");
        Logger.getInstance().info(reg.getInitstring() + "," + reg.getVersion() + "," + Integer.toString(reg.getDataLength()) + "\n");
        Logger.getInstance().info("File,Encoding,Checksum,File Size,Line Count,NC Line Count,Timestamp,Slot Index,Slot Length,Class Count, Method Count, Statement Count,Branch Count");
        reg.getProject().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Logger.getInstance().info(file.getPackagePath() + "," + file.getEncoding() + "," + file.getChecksum() + "," + file.getFilesize() + "," + file.getLineCount() + "," + file.getNcLineCount() + "," + DateFormat.getDateTimeInstance().format(new Long(file.getTimestamp())) + "," + ((FileInfo)file).getDataIndex() + "," + Integer.toString(((FileInfo)file).getDataLength()) + "," + Integer.toString(RegistryDumper.classCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.methodCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.statementCount((FileInfo)file)) + "," + Integer.toString(RegistryDumper.branchCount((FileInfo)file)) + ",");
            }
        });
    }
}

