/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import clover.org.apache.commons.lang.mutable.MutableLong;
import com.cenqua.clover.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class CoverageUtils {
    public static final int RLE_RUN_MARKER = -1;
    public static final int RLE_RUN_THRESHOLD = 3;

    public static void rleCompressAndWriteCoverage(DataOutputStream out, int[][] coverage, int numElements) throws IOException {
        int elementsWritten = 0;
        int intsWritten = 0;
        boolean inRun = false;
        int runCount = 0;
        int runValue = 0;
        for (int i = 0; i < coverage.length; ++i) {
            int[] section = coverage[i];
            int j = 0;
            while (j < section.length && elementsWritten < numElements) {
                if (!inRun) {
                    int value;
                    boolean startRun = true;
                    runValue = section[j];
                    for (int k = 1; k < 3; ++k) {
                        if (j + k < section.length && runValue == section[j + k]) continue;
                        startRun = false;
                        break;
                    }
                    if (startRun) {
                        runCount = 3;
                        inRun = true;
                        j += runCount;
                        continue;
                    }
                    out.writeInt((value = section[j++]) == -1 ? -2 : value);
                    ++intsWritten;
                    continue;
                }
                if (runValue == section[j]) {
                    ++runCount;
                    ++j;
                    continue;
                }
                out.writeInt(-1);
                out.writeInt(runCount);
                out.writeInt(runValue == -1 ? -2 : runValue);
                inRun = false;
                intsWritten += 3;
            }
            elementsWritten += j;
        }
        if (inRun) {
            out.writeInt(-1);
            out.writeInt(runCount);
            out.writeInt(runValue == -1 ? -2 : runValue);
            intsWritten += 3;
        }
        Logger.getInstance().debug("[wrote " + elementsWritten + " elements as " + intsWritten * 4 + " bytes (RLE)]");
    }

    public static void writeUncompressedCoverage(DataOutputStream out, int[][] coverage, int numElements) throws IOException {
        int written = 0;
        for (int i = 0; i < coverage.length; ++i) {
            int j;
            int[] section = coverage[i];
            for (j = 0; j < section.length && written < numElements; ++j) {
                out.writeInt(section[j]);
            }
            written += j;
        }
        Logger.getInstance().debug("[wrote " + written + " elements as " + coverage.length * 4 + " bytes (uncompressed)]");
    }

    public static int[] readCoverageAndSumCoverage(DataInputStream in, MutableLong sum) throws IOException {
        int offset;
        int elementCount = in.readInt();
        int[] elements = new int[elementCount];
        byte[] data = new byte[elementCount * 4];
        long localSum = 0L;
        int read = 0;
        for (offset = 0; read != -1 && offset != data.length; offset += read) {
            read = in.read(data, offset, data.length - offset);
        }
        try {
            int j = 0;
            int i = 0;
            while (i < elementCount) {
                int m;
                if ((m = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF) == -1) {
                    int v;
                    int c = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF;
                    if ((v = (data[j++] & 0xFF) << 24 | (data[j++] & 0xFF) << 16 | (data[j++] & 0xFF) << 8 | data[j++] & 0xFF) != 0) {
                        Arrays.fill(elements, i, i + c, v);
                        localSum += (long)(c * v);
                    }
                    i += c;
                    continue;
                }
                elements[i++] = m;
                localSum += (long)m;
            }
            Logger.getInstance().debug("[read " + elementCount + " elements as " + (offset + 1) + " bytes with sum " + localSum + "]");
            sum.setValue(localSum);
            return elements;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Recording corrupt");
        }
    }
}

