/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.math._BigDecimal;
import com.cenqua.clover.DefaultLogger;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.test.optimization.TestMethodCall;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SnapshotPrinter {
    private static int indent;
    static /* synthetic */ Class class$com$cenqua$clover$test$optimization$SnapshotPrinter;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            SnapshotPrinter.printUsage();
        } else {
            DefaultLogger logger = new DefaultLogger();
            SnapshotPrinter.prettyPrint(Snapshot.loadFrom(args[0]), logger, 2);
        }
    }

    private static void printUsage() {
        System.err.println("Usage:");
        StringBuffer stringBuffer = new StringBuffer().append("java ");
        Class<?> clazz = class$com$cenqua$clover$test$optimization$SnapshotPrinter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$test$optimization$SnapshotPrinter = new SnapshotPrinter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" <snapshot path>").toString());
    }

    public static void prettyPrint(Snapshot snapshot, Logger logger, int level) {
        if (snapshot != null) {
            Map.Entry entry;
            logger.log(level, "Loaded snapshot at: " + snapshot.getLocation(), null);
            logger.log(level, "Loaded snapshot for clover.db: " + snapshot.getInitString(), null);
            logger.log(level, "Snapshot's Clover version: " + snapshot.getCloverVersionInfo(), null);
            logger.log(level, "CLI's Clover version: " + snapshot.getCloverVersionInfo(), null);
            logger.log(level, "Versions: ", null);
            Iterator<Object> iterator = snapshot.getDbVersions().iterator();
            while (iterator.hasNext()) {
                ++indent;
                logger.log(level, "" + iterator.next(), null);
                --indent;
            }
            logger.log(level, "Known tests: ", null);
            iterator = snapshot.getTestLookup().entrySet().iterator();
            while (iterator.hasNext()) {
                ++indent;
                entry = (Map.Entry)iterator.next();
                String name = (String)entry.getKey();
                Set tests = (Set)entry.getValue();
                long duration = snapshot.calculateDurationOf(tests);
                logger.log(level, SnapshotPrinter.indent(name + " : duration " + SnapshotPrinter.durationAsString(duration)), null);
                Iterator iterator2 = tests.iterator();
                while (iterator2.hasNext()) {
                    ++indent;
                    TestMethodCall test = (TestMethodCall)iterator2.next();
                    long duration2 = snapshot.calculateDurationOf(Collections.singleton(test));
                    logger.log(level, SnapshotPrinter.indent(test.toString() + " : "), null);
                    --indent;
                }
                --indent;
            }
            logger.log(level, "Failing tests: ", null);
            iterator = snapshot.getFailingTestPaths().iterator();
            while (iterator.hasNext()) {
                ++indent;
                logger.log(level, SnapshotPrinter.indent((String)iterator.next()), null);
                --indent;
            }
            logger.log(level, "All files: ", null);
            iterator = snapshot.getFile2TestsMap().entrySet().iterator();
            while (iterator.hasNext()) {
                ++indent;
                entry = (Map.Entry)iterator.next();
                logger.log(level, SnapshotPrinter.indent((String)entry.getKey()), null);
                logger.log(level, SnapshotPrinter.indent("Hitting tests:"), null);
                Iterator iterator1 = ((Set)entry.getValue()).iterator();
                while (iterator1.hasNext()) {
                    ++indent;
                    logger.log(level, SnapshotPrinter.indent(iterator1.next().toString()), null);
                    --indent;
                }
                --indent;
            }
        }
    }

    private static String durationAsString(long duration) {
        return new Interval(_BigDecimal.valueOf(duration).divide(_BigDecimal.valueOf(1000L), 2, 4), 0).toSensibleString() + " (" + duration + " ms)";
    }

    private static String indent(String line) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buffer.append("\t");
        }
        buffer.append(line);
        return buffer.toString();
    }
}

