/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.test.optimization;

import clover.it.unimi.dsi.fastutil.objects.Object2LongMap;
import clover.it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataRange;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.test.optimization.Messages;
import com.cenqua.clover.test.optimization.OptimizationSession;
import com.cenqua.clover.test.optimization.TestMethodCall;
import com_cenqua_clover.CloverVersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot
implements Serializable {
    private static final long serialVersionUID = 6684083217918243192L;
    public static final long UNKNOWN_DURATION = Long.MIN_VALUE;
    private final String cloverVersionInfo = CloverVersionInfo.formatVersionInfo();
    private final Set<Long> dbVersions = new LinkedHashSet<Long>();
    private final String initString;
    private final Map<String, Set<TestMethodCall>> testLookup;
    private final Object2LongMap durationsForTests;
    private final Set<TestMethodCall> failingTests;
    private final Map<TestMethodCall, Map<String, SourceState>> perTestSourceStates;
    private long avgSetupTeardownDuration;
    private transient File location;
    private static boolean DEBUG;

    public Snapshot(CloverDatabase db, File locationTosnapshot) {
        this.initString = db.getInitstring();
        this.testLookup = new HashMap<String, Set<TestMethodCall>>();
        this.perTestSourceStates = new HashMap<TestMethodCall, Map<String, SourceState>>();
        this.durationsForTests = new Object2LongOpenHashMap(){
            private static final long serialVersionUID = 6851581250481388361L;

            public long defaultReturnValue() {
                return Long.MIN_VALUE;
            }
        };
        this.failingTests = new HashSet<TestMethodCall>();
        this.location = locationTosnapshot;
        this.updateFor(db);
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public void updateFor(CloverDatabase db) {
        long updateStart = System.currentTimeMillis();
        TestRunTimings testTimings = this.updateFailedTestsAndTestDurations(db);
        if (this.isFirstUpdate()) {
            this.avgSetupTeardownDuration = this.calcAvgSetupTeardownDuration(testTimings);
        }
        this.calcHits(db);
        Logger.getInstance().verbose(new StringBuffer().append("Took ").append(System.currentTimeMillis() - updateStart).append("ms to ").append(this.isFirstUpdate() ? "initialise" : "update").append(" the snapshot").toString());
        this.pushVersion(db);
    }

    private void pushVersion(CloverDatabase db) {
        this.dbVersions.add(new Long(db.getRegistry().getVersion()));
    }

    private boolean isFirstUpdate() {
        return this.dbVersions.size() == 0;
    }

    private TestRunTimings updateFailedTestsAndTestDurations(CloverDatabase db) {
        long earliestStart = Long.MAX_VALUE;
        long latestEnd = 0L;
        long totalTestTime = 0L;
        long started = System.currentTimeMillis();
        int testCount = 0;
        Set<TestCaseInfo> allTestCaseInfos = db.getCoverageData().getTests();
        for (TestCaseInfo tci : allTestCaseInfos) {
            ++testCount;
            long duration = tci.getEndTime() - tci.getStartTime();
            totalTestTime += duration;
            earliestStart = Math.min(earliestStart, tci.getStartTime());
            latestEnd = Math.max(latestEnd, tci.getEndTime());
            this.updatePerTestInfo(db, tci, duration);
        }
        Logger.getInstance().verbose(new StringBuffer().append("Took ").append(System.currentTimeMillis() - started).append("ms to process all test durations").toString());
        if (testCount == 0) {
            Logger.getInstance().verbose("No test results found in the Clover database. Please ensure the source files containing test classes have been instrumented by Clover and the tests have been run.");
        } else {
            Logger.getInstance().verbose(new StringBuffer().append("Number of test results found in the model: ").append(testCount).toString());
        }
        return new TestRunTimings(earliestStart, latestEnd, totalTestTime);
    }

    private void updatePerTestInfo(CloverDatabase db, TestCaseInfo tci, long duration) {
        TestMethodCall testCall = TestMethodCall.createFor(db.getFullModel(), tci);
        if (testCall != null) {
            this.addToTestlookup(testCall.getSourceMethodName(), testCall);
            if (testCall.isInheritedCall()) {
                this.addToTestlookup(testCall.getRuntimeMethodName(), testCall);
            }
            this.addToTestlookup(testCall.getPackagePath(), testCall);
            this.addToTestlookup(tci.getRuntimeTypeName(), testCall);
            if (tci.isSuccess()) {
                this.failingTests.remove(testCall);
            } else {
                this.failingTests.add(testCall);
            }
            if (DEBUG) {
                Logger.getInstance().debug(new StringBuffer().append("Duration for individual test '").append(testCall).append("' = ").append(duration).toString());
            }
            this.durationsForTests.put(testCall, duration);
        }
    }

    private void addToTestlookup(String key, TestMethodCall testCall) {
        HashSet<TestMethodCall> tests = this.testLookup.get(key);
        tests = tests == null ? new HashSet<TestMethodCall>() : tests;
        tests.add(testCall);
        this.testLookup.put(key, tests);
    }

    private void addToStates(TestMethodCall test, String path, SourceState state) {
        Map<String, SourceState> perTestMap = this.perTestSourceStates.get(test);
        if (perTestMap == null) {
            perTestMap = new HashMap<String, SourceState>();
            this.perTestSourceStates.put(test, perTestMap);
        }
        perTestMap.put(path, state);
    }

    private void calcHits(final CloverDatabase db) {
        long started = System.currentTimeMillis();
        db.getFullModel().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                String packagePath = file.getPackagePath();
                SourceState sourceState = new SourceState(file.getChecksum(), file.getFilesize());
                Set testsForFile = Snapshot.this.testsFor(db.getFullModel(), db.getTestHits((CoverageDataRange)((Object)file)));
                Iterator i$ = testsForFile.iterator();
                while (i$.hasNext()) {
                    TestMethodCall test = (TestMethodCall)i$.next();
                    Snapshot.this.addToStates(test, packagePath, sourceState);
                }
            }
        });
        Logger.getInstance().verbose(new StringBuffer().append("Took ").append(System.currentTimeMillis() - started).append("ms to correlate source files paths with test hits").toString());
    }

    private long calcAvgSetupTeardownDuration(TestRunTimings timings) {
        long duration = 0L;
        if (this.durationsForTests.size() > 1 && timings.totalTestTime > 0L && timings.latestEnd > timings.earliestStart) {
            long firstToLastTestDuration = timings.latestEnd - timings.earliestStart;
            Logger.getInstance().verbose(new StringBuffer().append("Measured first-to-last test duration = ").append(firstToLastTestDuration).append("ms").toString());
            Logger.getInstance().verbose(new StringBuffer().append("Aggregate test duration = ").append(timings.totalTestTime).append("ms").toString());
            Logger.getInstance().verbose(new StringBuffer().append("Number of test methods = ").append(this.durationsForTests.size()).toString());
            duration = Math.max(0L, (firstToLastTestDuration - timings.totalTestTime) / (long)(this.durationsForTests.size() - 1));
        }
        Logger.getInstance().debug(new StringBuffer().append("Calculated average per-test setup/teardown cost = ").append(duration).append("ms").toString());
        return duration;
    }

    private Set<TestMethodCall> testsFor(ProjectInfo project, Collection<TestCaseInfo> tcis) {
        HashSet<TestMethodCall> tests = new HashSet<TestMethodCall>();
        for (TestCaseInfo tci : tcis) {
            String testName = TestMethodCall.getSourceMethodNameFor(tci, project);
            Set<TestMethodCall> testsForName = testName == null ? null : this.testLookup.get(testName);
            if (testsForName == null) continue;
            tests.addAll(testsForName);
        }
        return tests;
    }

    public void store() throws IOException {
        if (!this.location.exists()) {
            if (this.location.getParentFile() != null && !this.location.getParentFile().exists()) {
                this.location.getParentFile().mkdirs();
            }
            this.location.createNewFile();
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.location));
        oos.writeObject(this);
        oos.close();
    }

    public static Snapshot generateFor(CloverDatabase db) {
        return new Snapshot(db, new File(Snapshot.fileNameForInitString(db.getInitstring())));
    }

    public static Snapshot generateFor(CloverDatabase db, String location) {
        return new Snapshot(db, new File(location));
    }

    public static Snapshot generateFor(String initString, String snapshotPath, CoverageDataSpec spec) throws CloverException {
        return new Snapshot(CloverDatabase.loadWithCoverage(initString, spec), new File(snapshotPath));
    }

    public static Snapshot generateFor(String initString) throws CloverException {
        return new Snapshot(CloverDatabase.loadWithCoverage(initString, new CoverageDataSpec()), Snapshot.fileForInitString(initString));
    }

    public static Snapshot loadFor(String initString) {
        return Snapshot.loadFrom(Snapshot.fileNameForInitString(initString));
    }

    public static Snapshot loadFrom(String path) {
        return Snapshot.loadFromFile(new File(path));
    }

    public static Snapshot loadFrom(File file) {
        return Snapshot.loadFromFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Snapshot loadFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            Snapshot snapshot;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
            try {
                long start = System.currentTimeMillis();
                Snapshot snapshot2 = (Snapshot)ois.readObject();
                Logger.getInstance().verbose(new StringBuffer().append("Took ").append(System.currentTimeMillis() - start).append("ms to load the snapshot file").toString());
                snapshot2.location = file;
                snapshot = snapshot2;
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                    throw throwable;
                }
                catch (InvalidClassException e) {
                    Logger.getInstance().debug(new StringBuffer().append("Failed to load snapshot file at ").append(file.getAbsolutePath()).toString(), e);
                    Logger.getInstance().warn(new StringBuffer().append("Failed to load snapshot file at ").append(file.getAbsolutePath()).append(" because it is no longer valid for this version of Clover").toString());
                }
                catch (Exception e) {
                    Logger.getInstance().debug(new StringBuffer().append("Failed to load snapshot file at ").append(file.getAbsolutePath()).toString(), e);
                    Logger.getInstance().warn(new StringBuffer().append("Failed to load snapshot file at ").append(file.getAbsolutePath()).toString());
                }
            }
            ois.close();
            return snapshot;
        } else {
            Logger.getInstance().verbose(new StringBuffer().append("Snapshot file at ").append(file.getAbsolutePath()).append(" exists / is file / can read: ").append(file.exists()).append(" / ").append(file.isFile()).append(" / ").append(file.canRead()).append(" / ").toString());
        }
        return null;
    }

    public boolean delete() {
        return this.location.exists() && this.location.delete();
    }

    public Set<String> getFailingTestPaths() {
        return this.pathsFor(this.failingTests);
    }

    private boolean isChangedFile(SourceState fileReference, BaseFileInfo file) {
        return fileReference != null && file instanceof FileInfo && ((FileInfo)file).changedFrom(fileReference.checksum, fileReference.filesize);
    }

    private Set<String> pathsFor(Set<TestMethodCall> tests) {
        HashSet<String> paths = new HashSet<String>(tests.size());
        for (TestMethodCall testReference : tests) {
            paths.add(testReference.getPackagePath());
        }
        return paths;
    }

    public static String fileNameForInitString(String initString) {
        return new StringBuffer().append(initString).append(".snapshot").toString();
    }

    public static File fileForInitString(String initString) {
        return new File(Snapshot.fileNameForInitString(initString));
    }

    public File getLocation() {
        return this.location;
    }

    public int getDbVersionCount() {
        return this.dbVersions.size();
    }

    public String getCloverVersionInfo() {
        return this.cloverVersionInfo;
    }

    public String getInitString() {
        return this.initString;
    }

    public Set getDbVersions() {
        return this.dbVersions;
    }

    long calculateDurationOf(Set<TestMethodCall> tests) {
        long duration = 0L;
        for (TestMethodCall test : tests) {
            long testFileDuration = this.durationsForTests.getLong(test);
            if (testFileDuration == Long.MIN_VALUE) continue;
            duration += testFileDuration;
        }
        return duration + (long)tests.size() * this.avgSetupTeardownDuration;
    }

    public boolean isTooStale(int maxOptimizedBuilds) {
        StringBuffer reason = new StringBuffer();
        boolean tooStale = this.isTooStale(maxOptimizedBuilds, reason);
        if (DEBUG) {
            Logger.getInstance().info(reason.toString());
        }
        return tooStale;
    }

    public boolean isTooStale(int maxOptimizedBuilds, StringBuffer reason) {
        if (!this.cloverVersionInfo.equals(CloverVersionInfo.formatVersionInfo())) {
            reason.append(Messages.noOptimizationBecauseOldVersion(this.cloverVersionInfo));
            return true;
        }
        if (this.getDbVersionCount() - 1 >= maxOptimizedBuilds) {
            reason.append(Messages.noOptimizationBecauseInaccurate(maxOptimizedBuilds, this.getDbVersionCount()));
            return true;
        }
        return false;
    }

    long getMostRecentDbVersion() {
        long version = 0L;
        for (Long dbVersion : this.dbVersions) {
            if (dbVersion <= version) continue;
            version = dbVersion;
        }
        return version;
    }

    boolean isTestAffectedByChanges(TestMethodCall test, Clover2Registry registry, OptimizationSession session) {
        boolean isAffected;
        Map<String, SourceState> perTestStates = this.perTestSourceStates.get(test);
        boolean bl = isAffected = perTestStates == null || this.hasChanges(test, perTestStates, registry, session);
        if (DEBUG) {
            if (perTestStates == null) {
                Logger.getInstance().info(new StringBuffer().append("Test ").append(test).append(" has no recorded coverage").toString());
            } else {
                Logger.getInstance().info(new StringBuffer().append("Test ").append(test).append(" was affected by changed source: ").append(isAffected).toString());
            }
        }
        return isAffected;
    }

    private boolean hasChanges(TestMethodCall testMethod, Map<String, SourceState> perTestStates, Clover2Registry registry, OptimizationSession session) {
        for (Map.Entry<String, SourceState> fileState : perTestStates.entrySet()) {
            BaseFileInfo fileInfo = registry.getProject().findFile(fileState.getKey());
            if (fileInfo != null && !this.isChangedFile(fileState.getValue(), fileInfo)) continue;
            if (DEBUG) {
                if (fileInfo == null) {
                    Logger.getInstance().info(new StringBuffer().append("Source file ").append(fileState.getKey()).append(" covered by test ").append(testMethod).append(" not found in model").toString());
                } else {
                    Logger.getInstance().info(new StringBuffer().append("Source file ").append(fileState.getKey()).append(" covered by test ").append(testMethod).append(" changed (was: ").append(fileState.getValue()).append(" now: ").append(new SourceState(fileInfo.getChecksum(), fileInfo.getFilesize())).append(")").toString());
                }
            }
            if (fileInfo != null) {
                session.addModifiedPath(fileState.getKey());
            }
            return true;
        }
        if (DEBUG) {
            Logger.getInstance().info(new StringBuffer().append("Test ").append(testMethod).append(" has no coverage or no source it covered has changed").toString());
        }
        return false;
    }

    Set<TestMethodCall> lookupTests(String name) {
        return this.testLookup.get(name);
    }

    Set<TestMethodCall> getFailingTests() {
        return this.failingTests;
    }

    Map<String, Set<TestMethodCall>> getTestLookup() {
        return this.testLookup;
    }

    Map<String, Collection<TestMethodCall>> getFile2TestsMap() {
        HashMap<String, Collection<TestMethodCall>> result = new HashMap<String, Collection<TestMethodCall>>();
        for (Map.Entry<TestMethodCall, Map<String, SourceState>> mapEntry : this.perTestSourceStates.entrySet()) {
            TestMethodCall test = mapEntry.getKey();
            Map<String, SourceState> value = mapEntry.getValue();
            for (String filePath : value.keySet()) {
                HashSet<TestMethodCall> tests = (HashSet<TestMethodCall>)result.get(filePath);
                if (tests == null) {
                    tests = new HashSet<TestMethodCall>();
                    result.put(filePath, tests);
                }
                tests.add(test);
            }
        }
        return result;
    }

    private static final class SourceState
    implements Serializable {
        private static final long serialVersionUID = -3186007190113270192L;
        private final long checksum;
        private final long filesize;

        SourceState(long checksum, long filesize) {
            this.checksum = checksum;
            this.filesize = filesize;
        }

        public String toString() {
            return "SourceState{checksum=" + this.checksum + ", filesize=" + this.filesize + '}';
        }
    }

    private static final class TestRunTimings {
        private final long earliestStart;
        private final long latestEnd;
        private final long totalTestTime;

        private TestRunTimings(long earliestStart, long latestEnd, long totalTestTime) {
            this.earliestStart = earliestStart;
            this.latestEnd = latestEnd;
            this.totalTestTime = totalTestTime;
        }
    }
}

