/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks.testng;

import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.cenqua.clover.test.optimization.LocalSnapshotOptimizer;
import com.cenqua.clover.test.optimization.OptimizationSession;
import com.cenqua.clover.test.optimization.Optimizer;
import com.cenqua.clover.test.optimization.Snapshot;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.testng.internal.annotations.IAnnotationTransformer;
import org.testng.internal.annotations.ITest;

public class CloverOptimizedTestSelector
implements IAnnotationTransformer {
    private Optimizer optimizer;
    private OptimizationSession session;

    public void transform(ITest annotation, Class clazz, Constructor constructor, Method method) {
        Optimizable testable;
        this.maybeInitializeOptimizer();
        if (this.optimizer.canOptimize() && ((testable = this.testableFor(clazz, constructor, method)) == null || !this.optimizer.include(testable, this.session))) {
            return;
        }
        this.addCloverOptimizedToGroup(annotation);
    }

    private void addCloverOptimizedToGroup(ITest annotation) {
        String[] groups = annotation.getGroups();
        if (groups == null || groups.length == 0) {
            groups = new String[]{"clover-optimized"};
        } else {
            ArrayList<String> groupsAsList = new ArrayList<String>(Arrays.asList(groups));
            groupsAsList.add("clover-optimized");
            groups = groupsAsList.toArray(new String[groupsAsList.size()]);
        }
        annotation.setGroups(groups);
    }

    private Optimizable testableFor(Class clazz, Constructor constructor, Method method) {
        Class<?> daRealClazz;
        Object object = clazz == null ? (method == null ? (constructor == null ? null : constructor.getDeclaringClass()) : method.getDeclaringClass()) : (daRealClazz = clazz);
        if (daRealClazz == null) {
            return null;
        }
        final StringBuffer name = new StringBuffer(daRealClazz.getName());
        if (name.indexOf("$") > -1) {
            name.delete(name.indexOf("$"), name.length());
        }
        return new Optimizable(){

            public String getName() {
                return name.toString();
            }
        };
    }

    public void maybeInitializeOptimizer() {
        if (this.optimizer == null) {
            String snapshotPath = System.getProperty("clover.test.snapshot");
            String initString = System.getProperty("clover.initstring");
            OptimizationOptions options = new OptimizationOptions.Builder().optimizableName("class").snapshot((File)(snapshotPath == null ? (initString == null ? null : Snapshot.fileForInitString(initString)) : new File(snapshotPath))).initString(initString).build();
            this.optimizer = new LocalSnapshotOptimizer(options);
            this.session = new OptimizationSession(options, false);
        }
    }
}

