/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesetFilter
implements HasMetricsFilter {
    private final Set<File> files = new HashSet<File>();
    private final Map<String, Set<String>> fileNamesToPaths = new HashMap<String, Set<String>>();

    public FilesetFilter(Project p, List<FileSet> fileSets) {
        for (FileSet fileset : fileSets) {
            File baseDir = fileset.getDir(p);
            Logger.getInstance().verbose(new StringBuffer().append("Scanning files to filter in ").append(baseDir).append(" ; exists = ").append(baseDir.exists()).append(" ; is directory = ").append(baseDir.isDirectory()).toString());
            String[] includedFiles = fileset.getDirectoryScanner(p).getIncludedFiles();
            for (int j = 0; j < includedFiles.length; ++j) {
                File file = new File(baseDir, includedFiles[j]);
                Logger.getInstance().verbose(new StringBuffer().append("Adding to fileset filter: ").append(file.getPath()).toString());
                Set<String> paths = this.fileNamesToPaths.get(file.getName());
                if (paths == null) {
                    paths = new HashSet<String>();
                    this.fileNamesToPaths.put(file.getName(), paths);
                }
                paths.add(file.getAbsolutePath());
                this.files.add(file);
            }
        }
    }

    @Override
    public boolean accept(HasMetrics hm) {
        if (hm instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)hm;
            if (this.exactMatch(fileInfo) || this.fuzzyMatch(fileInfo)) {
                Logger.getInstance().verbose(new StringBuffer().append("Including file ").append(fileInfo.getPhysicalFile().getPath()).toString());
                return true;
            }
            Logger.getInstance().verbose(new StringBuffer().append("Excluding file ").append(fileInfo.getPhysicalFile().getPath()).toString());
            return false;
        }
        return true;
    }

    private boolean exactMatch(FileInfo fileInfo) {
        return this.files.contains(fileInfo.getPhysicalFile());
    }

    private boolean fuzzyMatch(FileInfo fileInfo) {
        Set<String> paths = this.fileNamesToPaths.get(fileInfo.getName());
        if (paths != null) {
            String packagePath = fileInfo.getPackagePath();
            for (String path : paths) {
                if (!path.endsWith(packagePath)) continue;
                return true;
            }
        }
        return false;
    }
}

