/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.tasks.CloverReportTask;
import com.cenqua.clover.tasks.HistoryPointTask;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class CloverHtmlReportTask
extends CloverReportTask {
    private String title = "";
    private File outdir;
    private File historyoutfile;
    private final CloverReportTask.CurrentEx current = new CloverReportTask.CurrentEx();
    private File historyDir;
    private String historyIncludes;
    private boolean showUniqueCoverage = true;

    public void setOutdir(File outdir) {
        this.outdir = outdir;
        this.historyoutfile = outdir;
    }

    public void setHistorydir(File dir) {
        this.historyDir = dir;
    }

    public void setHistoryIncludes(String patternSpec) {
        this.historyIncludes = patternSpec;
    }

    public void setShowUniqueCoverage(boolean show) {
        this.showUniqueCoverage = show;
    }

    public void setTestResultsDir(File testResultDir) {
        FileSet resultsFileSet = new FileSet();
        resultsFileSet.setDir(testResultDir);
        resultsFileSet.setIncludes("TEST*.xml");
        this.current.addTestResults(resultsFileSet);
    }

    public void addColumns(Columns columns) {
        this.current.setColumns(columns);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMaxTestsPerFile(int max) {
        this.current.setMaxTestsPerFile(max);
    }

    public void setNumThreads(int threads) {
        this.current.setNumThreads(threads);
    }

    public void cloverExecute() {
        if (this.outdir == null) {
            throw new BuildException("'outdir' attribute is required.");
        }
        this.current.setFormat(this.getFormat());
        this.current.setTitle(this.title);
        this.current.setOutFile(this.outdir);
        this.current.setCoverageCacheSize(this.coverageCacheSize);
        this.current.setShowUniqueCoverage(this.showUniqueCoverage);
        this.addCurrent(this.current);
        if (this.historyDir != null) {
            CloverReportTask.HistoricalEx historical = new CloverReportTask.HistoricalEx();
            historical.setHistoryDir(this.historyDir);
            if (this.historyIncludes != null) {
                historical.setHistoryIncludes(this.historyIncludes);
            }
            if (!historical.getHistoryDir().exists() && !historical.getHistoryDir().mkdirs()) {
                throw new BuildException("Unable to create history dir '" + historical.getHistoryDir() + "'");
            }
            HistoryPointTask hptask = new HistoryPointTask();
            hptask.setProject(this.getProject());
            hptask.init();
            hptask.setHistoryDir(historical.getHistoryDir());
            hptask.setInitString(this.resolveInitString());
            hptask.setAlwaysReport(true);
            hptask.setTaskName(this.getTaskName());
            if (!this.current.getTestResults().isEmpty()) {
                hptask.addTestResults((FileSet)this.current.getTestResults().get(0));
            }
            hptask.cloverExecute();
            historical.setFormat(this.getFormat());
            historical.setTitle(this.title);
            historical.setOutFile(this.historyoutfile);
            historical.resolve(this.getProject());
            this.addHistorical(historical);
        }
        super.cloverExecute();
    }

    protected Format getFormat() {
        return Format.DEFAULT_HTML;
    }
}

