/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Column;
import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.json.JSONObject;
import com.cenqua.clover.reporters.json.JSONReportUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RenderMetricsJSONAction
implements Callable {
    private static ThreadLocal columns;
    private final HasMetrics mInfo;
    private final File mFile;
    private final HtmlRenderingSupport mHelper;
    private final CloverReportConfig mCfg;
    private final VelocityContext mCtx;

    public RenderMetricsJSONAction(VelocityContext ctx, HasMetrics configured, CloverReportConfig current, File outfile, HtmlRenderingSupport helper) {
        this.mInfo = configured;
        this.mCtx = ctx;
        this.mHelper = helper;
        this.mCfg = current;
        this.mFile = outfile;
    }

    public static void initThreadLocals() {
        columns = new ThreadLocal();
    }

    public static void resetThreadLocals() {
        columns = null;
    }

    public Object call() throws Exception {
        if (columns.get() == null) {
            List<Column> cols = this.mCfg.isColumnsSet() ? this.mCfg.getColumns().getProjectColumnsCopy() : Columns.getAllColumns();
            columns.set(cols);
        }
        this.render();
        return null;
    }

    public void render() throws Exception {
        Map columnValues = JSONReportUtils.collectColumnValuesFor((List)columns.get(), this.mInfo, this.mHelper);
        JSONObject json = new JSONObject().put("name", this.mInfo.getName()).put("title", this.mCfg.getTitle()).put("stats", columnValues);
        ArrayList<String> children = new ArrayList<String>();
        if (this.mInfo instanceof ProjectInfo) {
            ProjectInfo projectInfo = (ProjectInfo)this.mInfo;
            List<? extends BasePackageInfo> pkgs = projectInfo.getPackages();
            Iterator<? extends BasePackageInfo> iterator = pkgs.iterator();
            while (iterator.hasNext()) {
                children.add(((PackageInfo)iterator.next()).getPath());
            }
        } else if (this.mInfo instanceof PackageInfo) {
            List files = ((PackageInfo)this.mInfo).getFiles();
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                FileInfo info = (FileInfo)iterator.next();
                children.add(info.getName());
            }
        }
        json.put("children", children);
        this.mCtx.put("json", json);
        this.mCtx.put("callback", this.mCfg.getFormat().getCallback());
        HtmlReportUtil.mergeTemplateToFile(this.mFile, this.mCtx, "html_res/api-json.vm");
    }
}

