/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.RenderFileAction;
import com.cenqua.clover.reporters.html.source.LineRenderInfo;
import com.cenqua.clover.reporters.html.source.SourceRenderHelper;
import com.cenqua.clover.reporters.json.JSONObject;
import com.cenqua.clover.reporters.json.JSONReportUtils;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderFileJSONAction
extends RenderFileAction {
    public RenderFileJSONAction(FileInfo fileInfo, HtmlRenderingSupport renderingHelper, Current report, VelocityContext velocity, CloverDatabase database, ProjectInfo fullModel) {
        super(fileInfo, renderingHelper, report, velocity, database, fullModel, null);
    }

    @Override
    public void render() throws Exception {
        String basename = new File(this.fileInfo.getName()).getName();
        try {
            Map columnValues = JSONReportUtils.collectColumnValuesFor((List)columnsTL.get(), this.fileInfo, this.renderingHelper);
            SourceRenderHelper srh = new SourceRenderHelper(this.database, this.report, this.renderingHelper);
            FileInfo fcopy = this.fileInfo.copy((PackageInfo)this.fileInfo.getContainingPackage(), HasMetricsFilter.ACCEPT_ALL);
            LineRenderInfo[] lineInfos = srh.gatherSrcRenderInfo(this.velocity, fcopy, this.getContextSet(), "", this.testLineInfo);
            String apiJsonOutFilename = new StringBuffer().append(RenderFileJSONAction.createOutFileBaseName(basename)).append("java.js").toString();
            File apiJsonOutfile = CloverUtils.createOutFile(fcopy, apiJsonOutFilename, this.report.getOutFile());
            Collection<String> hitCounts = this.collectHitCounts(lineInfos);
            JSONObject json = new JSONObject();
            json.put("id", this.renderingHelper.getFileIdentifier(fcopy));
            json.put("stats", columnValues);
            json.put("lines", hitCounts);
            this.velocity.put("json", json.toString(2));
            this.velocity.put("callback", this.report.getFormat().getCallback());
            HtmlReportUtil.mergeTemplateToFile(apiJsonOutfile, this.velocity, "html_res/api-json.vm");
        }
        catch (Exception e) {
            Logger.getInstance().error(new StringBuffer().append("Invalid Java source found or Clover failed to parse it: ").append(this.fileInfo.getPhysicalFile().getAbsolutePath()).toString(), e);
        }
    }

    private Collection<String> collectHitCounts(LineRenderInfo[] lineInfos) {
        ArrayList<String> hitCounts = new ArrayList<String>();
        for (int i = 0; i < lineInfos.length; ++i) {
            LineRenderInfo lineInfo = lineInfos[i];
            hitCounts.add(lineInfo.coverageStr);
        }
        return hitCounts;
    }
}

