/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html.source.java;

import cloverantlr.Token;
import cloverantlr.TokenStreamException;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.UnicodeJavaLexer;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.reporters.html.source.SourceListener;
import com.cenqua.clover.reporters.html.source.SourceTraverser;
import com.cenqua.clover.reporters.html.source.java.JavaKeywords;
import com.cenqua.clover.reporters.html.source.java.JavaSourceListener;
import com.cenqua.clover.reporters.html.source.java.JavadocTags;
import java.io.Reader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTokenTraverser
implements SourceTraverser<JavaSourceListener> {
    @Override
    public void traverse(Reader sourceReader, FileInfo fileInfo, JavaSourceListener listener) throws TokenStreamException {
        Token token;
        UnicodeJavaLexer lexer = new UnicodeJavaLexer(sourceReader, new InstrumentationConfig());
        Token prev = token = lexer.nextToken();
        StringBuffer currentChunk = new StringBuffer();
        StringBuffer accumName = new StringBuffer();
        boolean gatherPkgIdent = false;
        boolean gatherImportIdent = false;
        listener.onStartDocument();
        while (prev != null && 1 != prev.getType()) {
            if (token != null && token.getType() == prev.getType()) {
                currentChunk.append(token.getText());
            } else {
                if (147 == prev.getType()) {
                    JavaTokenTraverser.processWhiteSpace(currentChunk.toString(), listener);
                } else if (143 == prev.getType()) {
                    listener.onStringLiteral(currentChunk.toString());
                } else if (148 == prev.getType()) {
                    listener.onCommentChunk(currentChunk.toString());
                } else if (149 == prev.getType()) {
                    JavaTokenTraverser.processComment(currentChunk.toString(), listener);
                } else if (JavaKeywords.contains(new Integer(prev.getType()))) {
                    listener.onKeyword(currentChunk.toString());
                    gatherPkgIdent = prev.getType() == 44;
                    gatherImportIdent = prev.getType() == 46;
                } else if (gatherPkgIdent || gatherImportIdent) {
                    if (45 == prev.getType()) {
                        if (gatherImportIdent) {
                            listener.onImport(accumName.toString());
                        }
                        accumName = new StringBuffer();
                        gatherPkgIdent = false;
                        gatherImportIdent = false;
                        listener.onChunk(currentChunk.toString());
                    } else if (51 == prev.getType()) {
                        accumName.append(currentChunk.toString());
                        listener.onChunk(currentChunk.toString());
                    } else if (50 == prev.getType()) {
                        accumName.append(currentChunk.toString());
                        if (gatherPkgIdent) {
                            listener.onPackageSegment(accumName.toString(), currentChunk.toString());
                        } else {
                            listener.onImportSegment(accumName.toString(), currentChunk.toString());
                        }
                    } else {
                        listener.onChunk(currentChunk.toString());
                    }
                } else if (50 == prev.getType()) {
                    listener.onIdentifier(currentChunk.toString());
                } else {
                    listener.onChunk(currentChunk.toString());
                }
                currentChunk = new StringBuffer();
                currentChunk.append(token.getText());
            }
            prev = token;
            token = lexer.nextToken();
        }
        listener.onEndDocument();
    }

    public static void processWhiteSpace(String whitespace, JavaSourceListener listener) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < whitespace.length(); ++i) {
            char c2;
            boolean atNewLine = false;
            char c1 = whitespace.charAt(i);
            char c = c2 = i + 1 < whitespace.length() ? whitespace.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                atNewLine = true;
                ++i;
            } else if (c1 == '\r' || c1 == '\n') {
                atNewLine = true;
            }
            if (atNewLine) {
                if (b.length() > 0) {
                    listener.onChunk(b.toString());
                    b = new StringBuffer();
                }
                listener.onNewLine();
                continue;
            }
            b.append(c1);
        }
        if (b.length() > 0) {
            listener.onChunk(b.toString());
        }
    }

    public static void processComment(String comment, JavaSourceListener listener) {
        StringBuffer b = new StringBuffer();
        boolean inTag = false;
        for (int i = 0; i < comment.length(); ++i) {
            char c2;
            boolean atNewLine = false;
            char c1 = comment.charAt(i);
            char c = c2 = i + 1 < comment.length() ? comment.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                atNewLine = true;
                ++i;
            } else if (c1 == '\r' || c1 == '\n') {
                atNewLine = true;
            }
            if (!inTag && c1 == '@' && Character.isLetter(c2)) {
                inTag = true;
                listener.onCommentChunk(b.toString());
                b = new StringBuffer();
            } else if (inTag && !Character.isLetter(c1)) {
                inTag = false;
                String tag = b.toString();
                if (JavadocTags.contains(tag.substring(1))) {
                    listener.onJavadocTag(tag);
                    b = new StringBuffer();
                }
            }
            if (atNewLine) {
                if (b.length() > 0) {
                    listener.onCommentChunk(b.toString());
                    b = new StringBuffer();
                }
                listener.onNewLine();
                continue;
            }
            b.append(c1);
        }
        if (b.length() > 0) {
            String left = b.toString();
            if (inTag && JavadocTags.contains(left)) {
                listener.onJavadocTag(left);
            } else {
                listener.onCommentChunk(left);
            }
        }
    }

    @Override
    public /* synthetic */ void traverse(Reader x0, FileInfo x1, SourceListener x2) throws Exception {
        this.traverse(x0, x1, (JavaSourceListener)x2);
    }
}

