/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import com.cenqua.clover.BitSetCoverageProvider;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.Formatting;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderTestResultAction
implements Callable {
    private static final ThreadLocal<ProjectInfo> REUSABLE_MODEL = new ThreadLocal();
    private static final ThreadLocal<ProjectInfo> CONFIGURABLE_MODEL = new ThreadLocal();
    private static final Comparator<HasMetrics> TARGET_CLASS_COMPARATOR = new Comparator<HasMetrics>(){

        @Override
        public int compare(HasMetrics m, HasMetrics m1) {
            return (int)(1000.0f * (m1.getMetrics().getPcCoveredElements() - m.getMetrics().getPcCoveredElements()));
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((HasMetrics)x0, (HasMetrics)x1);
        }
    };
    private final HtmlRenderingSupport renderingHelper;
    private final Current config;
    private final ProjectInfo fullModel;
    private final TestCaseInfo testCaseInfo;
    private final VelocityContext velocity;
    private final CloverDatabase database;
    private final ProjectInfo readOnlyModel;

    public RenderTestResultAction(TestCaseInfo testCaseInfo, HtmlRenderingSupport renderingHelper, Current config, ProjectInfo readOnlyModel, VelocityContext velocity, ProjectInfo fullModel, CloverDatabase database) {
        this.renderingHelper = renderingHelper;
        this.config = config;
        this.readOnlyModel = readOnlyModel;
        this.testCaseInfo = testCaseInfo;
        this.velocity = velocity;
        this.fullModel = fullModel;
        this.database = database;
    }

    @Override
    public Object call() throws Exception {
        if (REUSABLE_MODEL.get() == null) {
            REUSABLE_MODEL.set(this.readOnlyModel.copy());
        }
        if (CONFIGURABLE_MODEL.get() == null) {
            CONFIGURABLE_MODEL.set(this.readOnlyModel.copy());
        }
        FileInfo finfo = (FileInfo)this.testCaseInfo.getRuntimeType().getContainingFile();
        StringBuffer outname = this.renderingHelper.getTestFileName(this.testCaseInfo);
        File outfile = CloverUtils.createOutFile(finfo, outname.toString(), this.config.getOutFile());
        ProjectInfo projectInfo = CONFIGURABLE_MODEL.get();
        CoverageData data = this.database.getCoverageData();
        projectInfo.setDataProvider(new BitSetCoverageProvider(data.getHitsFor(this.testCaseInfo), data));
        List<? extends BaseClassInfo> classes = this.getCoverageByTest(projectInfo);
        if (this.config.isShowUniqueCoverage()) {
            this.gatherUniquenessVariables(classes);
        } else {
            this.velocity.put("showUnique", Boolean.FALSE);
        }
        this.velocity.put("currentPageURL", outname);
        Collections.sort(classes, TARGET_CLASS_COMPARATOR);
        this.velocity.put("targetClasses", classes);
        this.velocity.put("test", this.testCaseInfo);
        this.velocity.put("topLevel", Boolean.TRUE);
        this.velocity.put("projInfo", this.fullModel);
        this.velocity.put("hasResults", this.fullModel.hasTestResults());
        HtmlReportUtil.mergeTemplateToFile(outfile, this.velocity, "html_res/test-summary.vm");
        return null;
    }

    private void gatherUniquenessVariables(List classes) {
        LinkedHashMap uniqueCoverageMap = new LinkedHashMap();
        float uniqueElementsHit = this.buildUniqueCoverageMap(this.testCaseInfo, uniqueCoverageMap);
        int totalElementsHit = 0;
        for (ClassInfo info : classes) {
            totalElementsHit += info.getMetrics().getNumCoveredElements();
        }
        float pcUniqueElementsHit = (float)totalElementsHit > 0.0f ? uniqueElementsHit / (float)totalElementsHit : 0.0f;
        String pcUniqueCoverage = Formatting.getPercentStr(pcUniqueElementsHit);
        this.velocity.put("showUnique", Boolean.TRUE);
        this.velocity.put("uniqueTargetClasses", uniqueCoverageMap);
        this.velocity.put("pcUniqueCoverage", pcUniqueCoverage);
    }

    private int buildUniqueCoverageMap(TestCaseInfo tci, Map uniqueCoverageMap) {
        ProjectInfo projectInfo = this.createUniqueCoverageModel(tci);
        List<? extends BaseClassInfo> uniqueClassesCovered = this.getCoverageByTest(projectInfo);
        Collections.sort(uniqueClassesCovered, TARGET_CLASS_COMPARATOR);
        int uniqueElementsHit = 0;
        for (ClassInfo classInfo : uniqueClassesCovered) {
            uniqueCoverageMap.put(classInfo.getQualifiedName(), classInfo);
            uniqueElementsHit += classInfo.getMetrics().getNumCoveredElements();
        }
        return uniqueElementsHit;
    }

    private ProjectInfo createUniqueCoverageModel(TestCaseInfo tci) {
        ProjectInfo projectInfo = REUSABLE_MODEL.get();
        CoverageData data = this.database.getCoverageData();
        projectInfo.setDataProvider(new BitSetCoverageProvider(data.getUniqueHitsFor(tci), data));
        return projectInfo;
    }

    private List<? extends BaseClassInfo> getCoverageByTest(ProjectInfo projectInfo) {
        return projectInfo.getClasses(new HasMetricsFilter(){

            public boolean accept(HasMetrics hm) {
                return !((ClassInfo)hm).isTestClass() && hm.getMetrics().getNumCoveredElements() > 0;
            }
        });
    }
}

