/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.reporters.html.ClassInfoStatsCalculator;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.reporters.html.RenderCoverageCloudAction;
import com.cenqua.clover.reporters.html.TabInfo;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RenderPackageCoverageCloudAction
extends RenderCoverageCloudAction {
    private List childAndDescendantClasses;
    private PackageInfo pkg;
    private boolean siblingPagePresent;

    public RenderPackageCoverageCloudAction(VelocityContext context, File basePath, HtmlReporter.TreeInfo tree, PackageInfo pkg, boolean siblingPagePresent) {
        super(context, tree, RenderPackageCoverageCloudAction.sortedClassesFor(pkg), basePath);
        this.pkg = pkg;
        this.childAndDescendantClasses = this.sortedChildrenAndDescendantClassesFor(pkg);
        this.siblingPagePresent = siblingPagePresent;
    }

    private List sortedChildrenAndDescendantClassesFor(PackageInfo pkg) {
        return RenderPackageCoverageCloudAction.sortClasses(pkg.getChildAndDescendantClasses(), HasMetricsSupport.CMP_LEX);
    }

    private static List sortClasses(List classes, Comparator comparator) {
        if (classes != null) {
            Collections.sort(classes, comparator);
        }
        return classes;
    }

    private static List sortedClassesFor(PackageInfo pkg) {
        return RenderPackageCoverageCloudAction.sortClasses(pkg.getClasses(), HasMetricsSupport.CMP_LEX);
    }

    protected File createOutputDir() throws IOException {
        return CloverUtils.createOutDir(this.pkg, this.basePath);
    }

    protected TabInfo createRisksTab() {
        return new TabInfo("Package Risks", "pkg-risks.html", "help_pkg_risks");
    }

    protected void applySpecificProperties() {
        this.context.put("packageInfo", this.pkg);
        this.context.put("headerMetrics", this.pkg.getMetrics());
        this.context.put("headerMetricsRaw", this.pkg.getRawMetrics());
        this.context.put("classlist", this.classes);
        this.context.put("siblingPresent", this.siblingPagePresent);
        this.context.put("topLevel", Boolean.FALSE);
        this.context.put("pkg", this.pkg);
        HtmlReportUtil.addFilteredPercentageToContext(this.context, this.pkg);
    }

    protected void applyAxies(ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2) {
        this.applyAxis("shallow", axis1, axis2, this.classes);
        if (this.classes.size() < this.childAndDescendantClasses.size()) {
            this.context.put("showCloudDepthToggle", Boolean.TRUE);
            this.applyAxis("deep", axis1, axis2, this.childAndDescendantClasses);
        }
    }
}

