/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import com.cenqua.clover.Logger;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.html.source.LineRenderInfo;
import com.cenqua.clover.reporters.json.JSONException;
import com.cenqua.clover.reporters.json.JSONObject;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONObjectFactory {
    public static JSONObject getJSONTestTargets(Map targetMethods, Map targetElements) throws JSONException {
        JSONObject jsonTestTargets = new JSONObject();
        Iterator it = targetMethods.keySet().iterator();
        while (it.hasNext()) {
            TestCaseInfo testcase = (TestCaseInfo)it.next();
            BitSet methodSet = (BitSet)targetMethods.get(testcase);
            BitSet elementSet = (BitSet)targetElements.get(testcase);
            HashMap<String, Object> test = new HashMap<String, Object>();
            test.put("pass", testcase.isSuccess());
            test.put("name", testcase.getTestName());
            ArrayList methods = new ArrayList();
            int i = methodSet.nextSetBit(0);
            while (i >= 0) {
                HashMap<String, Integer> method = new HashMap<String, Integer>();
                method.put("sl", new Integer(i));
                methods.add(method);
                i = methodSet.nextSetBit(i + 1);
            }
            test.put("methods", methods);
            ArrayList statements = new ArrayList();
            if (elementSet != null) {
                int i2 = elementSet.nextSetBit(0);
                while (i2 >= 0) {
                    HashMap<String, Integer> statement = new HashMap<String, Integer>();
                    statement.put("sl", new Integer(i2));
                    statements.add(statement);
                    i2 = elementSet.nextSetBit(i2 + 1);
                }
            }
            test.put("statements", statements);
            jsonTestTargets.put("test_" + testcase.getId(), test);
        }
        return jsonTestTargets;
    }

    public static JSONObject getJSONPageData(FileInfo fileInfo) throws JSONException {
        JSONObject jsonPageData = new JSONObject();
        ArrayList classList = new ArrayList();
        Iterator it = fileInfo.getClasses().iterator();
        while (it.hasNext()) {
            ClassInfo classInfo = (ClassInfo)it.next();
            HashMap<String, Object> classMap = new HashMap<String, Object>();
            classMap.put("id", new Integer(classInfo.getDataIndex()));
            classMap.put("sl", new Integer(classInfo.getStartLine()));
            classMap.put("el", new Integer(classInfo.getEndLine()));
            classMap.put("name", classInfo.getName());
            ArrayList methods = new ArrayList();
            MethodInfo[] methodArray = classInfo.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                MethodInfo methodInfo = methodArray[i];
                HashMap<String, Integer> method = new HashMap<String, Integer>();
                method.put("sl", new Integer(methodInfo.getStartLine()));
                method.put("el", new Integer(methodInfo.getEndLine()));
                method.put("sc", new Integer(methodInfo.getStartColumn()));
                methods.add(method);
            }
            classMap.put("methods", methods);
            classList.add(classMap);
        }
        jsonPageData.put("classes", classList);
        return jsonPageData;
    }

    public static List getJSONSrcFileLines(LineRenderInfo[] renderInfos, String name) {
        ArrayList srcFileLines = new ArrayList();
        ArrayList<Object> srcFileLine = new ArrayList<Object>();
        srcFileLine.add("");
        srcFileLines.add(srcFileLine);
        for (int i = 0; i < renderInfos.length; ++i) {
            srcFileLine = new ArrayList();
            LineRenderInfo info = renderInfos[i];
            if (info == null) {
                Logger.getInstance().debug("LineRenderInfo is null for file '" + name + "'.");
                continue;
            }
            List testHits = info.getTestHits();
            if (testHits == null) {
                Logger.getInstance().debug("testHits is null for file '" + name + "'.");
                continue;
            }
            Iterator it = testHits.iterator();
            while (it.hasNext()) {
                srcFileLine.add(((TestCaseInfo)it.next()).getId());
            }
            srcFileLines.add(srcFileLine);
        }
        return srcFileLines;
    }
}

