/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.util._Arrays;
import com.cenqua.clover.BitSetCoverageProvider;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.Logger;
import com.cenqua.clover.TestResultProcessor;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Type;
import com.cenqua.clover.util.FilterUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Current
extends CloverReportConfig {
    private boolean summary;
    private static final String ERR_INITSTRING_NOT_SPECIFIED = "initstring not specified.";
    public static final Current DEFAULT_HTML = new Current(false);
    public static final Current DEFAULT_XML = new Current(false);
    public static final Current DEFAULT_PDF = new Current(true);
    private int maxTestsPerFile = -1;
    private boolean includeFailedTestCoverage = false;
    private List testSourceFiles = new ArrayList();
    private List globalFileNames = new ArrayList();
    private int numThreads = 2;
    private Interval timeOut = new Interval(9223372036854775L, 0);
    private boolean showUniqueCoverage = true;
    protected List testResultFiles;

    public Current() {
    }

    public Current(Current that) {
        this.summary = that.summary;
    }

    public Current(boolean summary) {
        this.summary = summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public boolean getSummary() {
        return this.summary;
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.getInitString() == null || this.getInitString().length() == 0) {
            this.setFailureReason(ERR_INITSTRING_NOT_SPECIFIED);
            return false;
        }
        if (this.getFormat() == null) {
            if (this.getSummary()) {
                this.setFormat(Format.DEFAULT_PDF);
            } else {
                this.setFormat(Format.DEFAULT_XML);
            }
        }
        if (this.getFormat().getType() == null) {
            this.setFailureReason("You need to set the report type");
            return false;
        }
        if (this.getFormat().in(new Type[]{Type.PDF}) && !this.getSummary()) {
            this.setFailureReason("Can only do summary reports in PDF");
            return false;
        }
        if (this.numThreads < 0) {
            this.setFailureReason("numThreads must be greater than or equal to zero, not: " + this.numThreads);
            return false;
        }
        return true;
    }

    public String toString() {
        return "Current[" + this.getFormat().getType() + ", " + this.getOutFile().getAbsolutePath() + "]";
    }

    public void addGlobalFileName(String fileName) {
        this.globalFileNames.add(fileName);
    }

    public void addTestResultFile(File file) {
        if (this.testResultFiles == null) {
            this.testResultFiles = new ArrayList();
        }
        this.testResultFiles.add(file);
    }

    public void addTestSourceFile(File file) {
        this.testSourceFiles.add(file);
    }

    public List getTestSourceFiles() {
        return Collections.unmodifiableList(this.testSourceFiles);
    }

    public List getGlobalSourceFileNames() {
        return Collections.unmodifiableList(this.globalFileNames);
    }

    public CloverDatabase getCoverageDatabase() throws CloverException {
        boolean hasTestResult;
        this.setLoadTestResults(this.testResultFiles == null);
        CloverDatabase db = super.getCoverageDatabase();
        try {
            if (!this.isLoadTestResults() && db.getTestOnlyModel() != null) {
                TestResultProcessor.addTestResultsToModel(db.getTestOnlyModel(), this.testResultFiles);
            }
        }
        catch (CloverException e) {
            Logger.getInstance().error("Error parsing test results: " + e.getMessage() + " - Test results will not be included.");
        }
        boolean bl = hasTestResult = db.getTestOnlyModel() != null && db.getTestOnlyModel().hasTestResults();
        if (hasTestResult && !this.isIncludeFailedTestCoverage()) {
            CoverageData data = db.getCoverageData();
            BitSetCoverageProvider provider = new BitSetCoverageProvider(data.getPassOnlyAndIncidentalHits(), data);
            db.getAppOnlyModel().setDataProvider(provider);
            db.getTestOnlyModel().setDataProvider(provider);
            db.getFullModel().setDataProvider(provider);
            db.getFullModel().setHasTestResults(hasTestResult);
        }
        if (this.isIncludeFailedTestCoverage() && !hasTestResult) {
            Logger.getInstance().debug("includeFailedTestCoverage='" + this.isIncludeFailedTestCoverage() + "', however no test results were found.");
        }
        return db;
    }

    protected HasMetricsFilter.Invertable effectiveTestFilter() {
        if (this.testSourceFiles.size() > 0) {
            return new FileSetTestFilter();
        }
        HasMetricsFilter.Invertable filter = this.getTestFilter();
        return filter != null ? filter : new DefaultTestFilter();
    }

    public int getMaxTestsPerFile() {
        return this.maxTestsPerFile;
    }

    public void setMaxTestsPerFile(int maxTestsPerFile) {
        this.maxTestsPerFile = maxTestsPerFile;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public boolean isShowUniqueCoverage() {
        return this.showUniqueCoverage;
    }

    public void setShowUniqueCoverage(boolean showUniqueCoverage) {
        this.showUniqueCoverage = showUniqueCoverage;
    }

    public boolean isIncludeFailedTestCoverage() {
        return this.includeFailedTestCoverage;
    }

    public void setIncludeFailedTestCoverage(boolean includeFailedTestCoverage) {
        this.includeFailedTestCoverage = includeFailedTestCoverage;
    }

    public Interval getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(String timeOutDescription) {
        this.timeOut = new Interval(timeOutDescription);
    }

    public static class EmptyTestFilter
    extends HasMetricsFilter.BaseInvertable {
        public EmptyTestFilter() {
            this(false);
        }

        private EmptyTestFilter(boolean inverted) {
            super(inverted);
        }

        public EmptyTestFilter invert() {
            return new EmptyTestFilter(!this.isInverted());
        }

        public boolean accept(HasMetrics hm) {
            return this.isInverted();
        }

        public /* synthetic */ HasMetricsFilter.BaseInvertable invert() {
            return this.invert();
        }

        public /* synthetic */ HasMetricsFilter.Invertable invert() {
            return this.invert();
        }
    }

    public static class AntPatternTestFilter
    extends HasMetricsFilter.BaseInvertable {
        private final String[] includeFilter;
        private final String[] excludeFilter;
        private final String projectRoot;

        private AntPatternTestFilter(boolean inverted, String projectRoot, String[] includePattern, String[] excludePattern) {
            super(inverted);
            this.projectRoot = projectRoot == null || projectRoot.endsWith("/") ? projectRoot : projectRoot + '/';
            this.includeFilter = includePattern;
            this.excludeFilter = excludePattern;
        }

        public AntPatternTestFilter(String projectRoot, String[] includePattern, String[] excludePattern) {
            this(false, projectRoot, includePattern, excludePattern);
        }

        public AntPatternTestFilter invert() {
            return new AntPatternTestFilter(!this.isInverted(), this.projectRoot, this.includeFilter, this.excludeFilter);
        }

        public boolean accept(HasMetrics hm) {
            if (hm instanceof ClassInfo) {
                ClassInfo ci = (ClassInfo)hm;
                File file = ((FileInfo)ci.getContainingFile()).getPhysicalFile();
                String path = file.getPath();
                String relative = this.projectRoot != null && path.startsWith(this.projectRoot) ? path.substring(this.projectRoot.length()) : path;
                return this.isInverted() ^ FilterUtils.isIncluded(relative, this.excludeFilter, this.includeFilter, false);
            }
            return true;
        }

        public String toString() {
            return "AntPatternTestFilter:[" + this.projectRoot + "]" + _Arrays.toString(this.includeFilter) + _Arrays.toString(this.excludeFilter);
        }

        public /* synthetic */ HasMetricsFilter.BaseInvertable invert() {
            return this.invert();
        }

        public /* synthetic */ HasMetricsFilter.Invertable invert() {
            return this.invert();
        }
    }

    public static class DefaultTestFilter
    extends HasMetricsFilter.BaseInvertable {
        public DefaultTestFilter() {
            this(false);
        }

        protected DefaultTestFilter(boolean inverted) {
            super(inverted);
        }

        public DefaultTestFilter invert() {
            return new DefaultTestFilter(!this.isInverted());
        }

        public boolean accept(HasMetrics hm) {
            if (hm instanceof ClassInfo) {
                ClassInfo classInfo = (ClassInfo)hm;
                return this.isInverted() ^ (classInfo.isTestClass() || classInfo.getContainingFile().isTestFile());
            }
            return true;
        }

        public /* synthetic */ HasMetricsFilter.BaseInvertable invert() {
            return this.invert();
        }

        public /* synthetic */ HasMetricsFilter.Invertable invert() {
            return this.invert();
        }
    }

    public class FileSetTestFilter
    extends HasMetricsFilter.BaseInvertable {
        public FileSetTestFilter() {
            this(false);
        }

        private FileSetTestFilter(boolean inverted) {
            super(inverted);
        }

        public FileSetTestFilter invert() {
            return new FileSetTestFilter(!this.isInverted());
        }

        public boolean accept(HasMetrics hm) {
            if (hm instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)hm;
                return this.isInverted() ^ Current.this.testSourceFiles.contains(fileInfo.getPhysicalFile());
            }
            return true;
        }

        public /* synthetic */ HasMetricsFilter.BaseInvertable invert() {
            return this.invert();
        }

        public /* synthetic */ HasMetricsFilter.Invertable invert() {
            return this.invert();
        }
    }

    public static class SourceFileFilter
    extends HasMetricsFilter.BaseInvertable {
        public SourceFileFilter() {
            this(false);
        }

        private SourceFileFilter(boolean inverted) {
            super(inverted);
        }

        public SourceFileFilter invert() {
            return new SourceFileFilter(!this.isInverted());
        }

        public boolean accept(HasMetrics hm) {
            if (hm instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)hm;
                return this.isInverted() ^ !fileInfo.isTestFile();
            }
            return true;
        }

        public /* synthetic */ HasMetricsFilter.BaseInvertable invert() {
            return this.invert();
        }

        public /* synthetic */ HasMetricsFilter.Invertable invert() {
            return this.invert();
        }
    }
}

