/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceInfo {
    private List<TraceEntry> entries = new ArrayList<TraceEntry>();
    private TestCaseInfo originatingTest;

    public StackTraceInfo(TestCaseInfo originatingTest, String fullTrace) {
        this.originatingTest = originatingTest;
        LineNumberReader lineReader = new LineNumberReader(new StringReader(fullTrace));
        try {
            String line = lineReader.readLine();
            TraceEntry prev = null;
            int id = 0;
            while (line != null) {
                TraceEntry cur = new TraceEntry(this, id++, prev, line);
                this.entries.add(cur);
                if (prev != null) {
                    prev.setDown(cur);
                }
                prev = cur;
                line = lineReader.readLine();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public TestCaseInfo getOriginatingTest() {
        return this.originatingTest;
    }

    public void setOriginatingTest(TestCaseInfo originatingTest) {
        this.originatingTest = originatingTest;
    }

    public void resolve(ProjectInfo proj) {
        Iterator<TraceEntry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            TraceEntry traceEntry = iterator.next();
            traceEntry.resolve(proj);
        }
    }

    public List getEntries() {
        return this.entries;
    }

    public static class TraceEntry {
        private static final String FILE_REGEXP = "[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.java:([0-9]+)";
        private static final Pattern TRACE_LINE_PATTERN = Pattern.compile("((([\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.)*[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*)\\.(?:\\<)?[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*(?:\\>)?)\\(([\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.java:([0-9]+)|Unknown Source)\\)");
        private static final Pattern LINE_NUMBER_PATTERN = Pattern.compile("[\\p{Alpha}\\$_][\\p{Alnum}\\$_]*\\.java:([0-9]+)");
        private StackTraceInfo parentTrace;
        private int id;
        private String line;
        private TraceEntry up;
        private TraceEntry down;
        private WeakReference<FileInfo> containingFile = new WeakReference<Object>(null);
        private int lineNum = -1;
        private String linePrefix;
        private String linkableLineSegment;

        public TraceEntry(StackTraceInfo parentTrace, int id, TraceEntry up, String line) {
            this.parentTrace = parentTrace;
            this.id = id;
            this.up = up;
            this.line = line;
        }

        public StackTraceInfo getParentTrace() {
            return this.parentTrace;
        }

        public int getId() {
            return this.id;
        }

        public String getLine() {
            return this.line;
        }

        public String getLinePrefix() {
            return this.linePrefix;
        }

        public String getLinkableLineSegment() {
            return this.linkableLineSegment;
        }

        public TraceEntry getUp() {
            return this.up;
        }

        public TraceEntry getDown() {
            return this.down;
        }

        public void setDown(TraceEntry down) {
            this.down = down;
        }

        public FileInfo getContainingFile() {
            return (FileInfo)this.containingFile.get();
        }

        public int getLineNum() {
            return this.lineNum;
        }

        public boolean isResolved() {
            return this.containingFile.get() != null;
        }

        public boolean resolve(ProjectInfo proj) {
            Matcher matcher = TRACE_LINE_PATTERN.matcher(this.line);
            boolean resolved = false;
            if (matcher.find()) {
                this.linePrefix = this.line.substring(0, matcher.start());
                this.linkableLineSegment = this.line.substring(matcher.start());
                String fqcn = matcher.group(2).replace('$', '.');
                ClassInfo clazz = (ClassInfo)proj.findClass(fqcn);
                if (clazz != null) {
                    FileInfo fileInfo = (FileInfo)clazz.getContainingFile();
                    this.containingFile = new WeakReference<FileInfo>(fileInfo);
                    String lineStr = matcher.group(4);
                    if (LINE_NUMBER_PATTERN.matcher(lineStr).matches()) {
                        this.lineNum = Integer.parseInt(matcher.group(5));
                        fileInfo.addFailStackEntry(this.lineNum, this);
                    }
                    resolved = true;
                }
            }
            return resolved;
        }
    }
}

