/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.cenqua.clover.registry.SourceRegion;
import java.io.IOException;
import java.util.Comparator;

public class FixedSourceRegion
implements SourceRegion,
TaggedPersistent {
    protected final int startLine;
    protected final int startColumn;
    protected final int endLine;
    protected final int endColumn;
    public static final Comparator SOURCE_ORDER_COMP = new RegionStartComparator();

    public FixedSourceRegion(int startLine, int startColumn) {
        this(startLine, startColumn, startLine, startColumn);
    }

    public FixedSourceRegion(SourceRegion other) {
        this(other.getStartLine(), other.getStartColumn(), other.getEndLine(), other.getEndColumn());
    }

    public FixedSourceRegion(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedSourceRegion that = (FixedSourceRegion)o;
        if (this.endColumn != that.endColumn) {
            return false;
        }
        if (this.endLine != that.endLine) {
            return false;
        }
        if (this.startColumn != that.startColumn) {
            return false;
        }
        return this.startLine == that.startLine;
    }

    public int hashCode() {
        int result = this.startLine;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endColumn;
        return result;
    }

    public String toString() {
        return "{" + this.startLine + ", " + this.startColumn + ", " + this.endLine + ", " + this.endColumn + '}';
    }

    public static FixedSourceRegion of(SourceRegion region) {
        return region instanceof FixedSourceRegion ? (FixedSourceRegion)region : new FixedSourceRegion(region);
    }

    public void write(TaggedDataOutput out) throws IOException {
        FixedSourceRegion.writeRaw(this, out);
    }

    public static void writeRaw(SourceRegion region, TaggedDataOutput out) throws IOException {
        out.writeInt(region.getStartLine());
        out.writeInt(region.getStartColumn());
        out.writeInt(region.getEndLine());
        out.writeInt(region.getEndColumn());
    }

    public static FixedSourceRegion read(TaggedDataInput in) throws IOException {
        return new FixedSourceRegion(in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    public static class RegionStartComparator
    implements Comparator {
        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null) {
                return -1;
            }
            if (obj2 == null) {
                return 1;
            }
            SourceRegion reg1 = (SourceRegion)obj1;
            SourceRegion reg2 = (SourceRegion)obj2;
            int sld = reg1.getStartLine() - reg2.getStartLine();
            if (sld == 0) {
                int scd = reg1.getStartColumn() - reg2.getStartColumn();
                if (scd == 0) {
                    int eld = reg1.getEndLine() - reg2.getEndLine();
                    if (eld == 0) {
                        return reg1.getEndColumn() - reg2.getEndColumn();
                    }
                    return eld;
                }
                return scd;
            }
            return sld;
        }
    }
}

