/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.context;

import com.atlassian.clover.instr.java.FileStructureInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.cenqua.clover.context.RegexpContext;
import java.io.IOException;
import java.util.regex.Pattern;

public class MethodRegexpContext
extends RegexpContext
implements TaggedPersistent {
    private int maxComplexity;

    public MethodRegexpContext(MethodRegexpContext ctx) {
        this(ctx.getIndex(), ctx.getName(), ctx.getPattern(), ctx.getMaxComplexity());
    }

    public MethodRegexpContext(String name, Pattern pattern) {
        this(-1, name, pattern, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(String name, Pattern pattern, int maxComplexity) {
        this(-1, name, pattern, maxComplexity);
    }

    public MethodRegexpContext(int index, String name, Pattern pattern) {
        this(index, name, pattern, Integer.MAX_VALUE);
    }

    public MethodRegexpContext(int index, String name, Pattern pattern, int maxComplexity) {
        super(index, name, pattern);
        this.maxComplexity = maxComplexity;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public boolean matches(FileStructureInfo.MethodMarker methodMarker) {
        return super.matches(methodMarker.getNormalisedSignature()) && methodMarker.getMethod().getMetrics().getComplexity() <= this.maxComplexity;
    }

    public boolean isEquivalent(RegexpContext other) {
        return other instanceof MethodRegexpContext && ((MethodRegexpContext)other).getMaxComplexity() == this.maxComplexity && super.isEquivalent(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodRegexpContext that = (MethodRegexpContext)o;
        return this.maxComplexity == that.maxComplexity;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxComplexity;
        return result;
    }

    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.getName());
        out.writeInt(this.getIndex());
        out.writeUTF(this.getPattern().pattern());
        out.writeInt(this.maxComplexity);
    }

    public static MethodRegexpContext read(TaggedDataInput in) throws IOException {
        String name = in.readUTF();
        int index = in.readInt();
        Pattern pattern = Pattern.compile(in.readUTF());
        int maxComplexity = in.readInt();
        return new MethodRegexpContext(index, name, pattern, maxComplexity);
    }
}

