/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.cfg;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.math._BigDecimal;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;

public class Interval {
    private static final BigDecimal POINT_FIVE = new BigDecimal(0.5);
    public static final int UNIT_SECOND = 0;
    public static final int UNIT_MINUTE = 1;
    public static final int UNIT_HOUR = 2;
    public static final int UNIT_DAY = 3;
    public static final int UNIT_WEEK = 4;
    public static final int UNIT_MONTH = 5;
    public static final int UNIT_YEAR = 6;
    public static final Interval ZERO_SECONDS = new Interval(0L, 0);
    public static final Interval DEFAULT_SPAN = new Interval(Integer.MAX_VALUE, 0);
    private static final int[] UNITS = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final Interval ZERO_INTERVAL = new Interval(0L, 3);
    private static final BigDecimal[] MULTIPLIERS = new BigDecimal[]{_BigDecimal.valueOf(1L), _BigDecimal.valueOf(60L), _BigDecimal.valueOf(60L), _BigDecimal.valueOf(24L), _BigDecimal.valueOf(7L), new BigDecimal(4.348), _BigDecimal.valueOf(12L)};
    private static final String[] NAMES = new String[]{"second", "minute", "hour", "day", "week", "month", "year"};
    private BigDecimal magnitude = null;
    private int unit = 3;

    public Interval(BigDecimal magnitude, int unit) {
        this.magnitude = magnitude;
        this.unit = unit;
    }

    public Interval(long magnitude, int unit) {
        this(_BigDecimal.valueOf(magnitude), unit);
    }

    public Interval(double magnitude, int unit) {
        this(new BigDecimal(magnitude), unit);
    }

    public Interval(String timeDescription, int defaultUnit) {
        this.unit = defaultUnit;
        this.initialise(timeDescription);
    }

    public Interval(String timeDescription) {
        this.initialise(timeDescription);
    }

    private void initialise(String timeDescription) {
        String amountString;
        int unitIndex = -1;
        boolean digitSeen = false;
        StringCharacterIterator sci = new StringCharacterIterator(timeDescription.toLowerCase());
        char c = sci.first();
        while (c != '\uffff') {
            if (Character.isDigit(c)) {
                digitSeen = true;
            } else if (!Character.isWhitespace(c) && c != '.' && (c != '-' || digitSeen)) {
                switch (c) {
                    case 's': {
                        this.unit = 0;
                        break;
                    }
                    case 'm': {
                        this.unit = 1;
                        int index = sci.getIndex() + 1;
                        if (index == timeDescription.length() || timeDescription.charAt(index) != 'o') break;
                        this.unit = 5;
                        break;
                    }
                    case 'h': {
                        this.unit = 2;
                        break;
                    }
                    case 'd': {
                        this.unit = 3;
                        break;
                    }
                    case 'w': {
                        this.unit = 4;
                        break;
                    }
                    case 'y': {
                        this.unit = 6;
                    }
                }
                unitIndex = sci.getIndex();
                break;
            }
            c = sci.next();
        }
        String string = amountString = unitIndex == -1 ? timeDescription.trim() : timeDescription.substring(0, unitIndex).trim();
        if (amountString.length() == 0) {
            throw new NumberFormatException("Intervals must have a magnitude - not found in '" + timeDescription + "'");
        }
        this.magnitude = new BigDecimal(amountString.trim());
    }

    public BigDecimal getValueInUnits(int desiredUnit) {
        BigDecimal adjustedMagnitude;
        block3: {
            block2: {
                adjustedMagnitude = this.magnitude;
                if (desiredUnit >= this.unit) break block2;
                for (int i = this.unit; i != desiredUnit; --i) {
                    adjustedMagnitude = adjustedMagnitude.multiply(MULTIPLIERS[i]);
                }
                break block3;
            }
            if (desiredUnit <= this.unit) break block3;
            for (int i = desiredUnit; i != this.unit; --i) {
                adjustedMagnitude = adjustedMagnitude.divide(MULTIPLIERS[i], 2, 4);
            }
        }
        return adjustedMagnitude;
    }

    public long getValueInMillis() {
        BigDecimal secs = this.getValueInUnits(0);
        return secs.longValue() * 1000L;
    }

    public String toString(int desiredUnit) {
        BigDecimal adjustedMag = this.getValueInUnits(desiredUnit);
        String unitName = NAMES[desiredUnit];
        String description = adjustedMag.toString() + " " + unitName + (adjustedMag.compareTo(_BigDecimal.valueOf(1L)) == 0 ? "" : "s");
        return description;
    }

    public String toIntString(int desiredUnit) {
        BigDecimal adjustedMag = this.getValueInUnits(desiredUnit);
        String unitName = NAMES[desiredUnit];
        String description = adjustedMag.longValue() + " " + unitName + (adjustedMag.compareTo(_BigDecimal.valueOf(1L)) == 0 ? "" : "s");
        return description;
    }

    public String toString() {
        return this.toString(this.unit);
    }

    public String toSensibleString() {
        for (int i = UNITS.length - 1; i >= 0; --i) {
            BigDecimal val = this.getValueInUnits(UNITS[i]);
            val.setScale(0, 4);
            if (val.longValue() < 1L) continue;
            String description = val.longValue() + " " + NAMES[i] + (val.intValue() == 1 ? "" : "s");
            return description;
        }
        return this.toString();
    }

    public int getUnit() {
        return this.unit;
    }

    public BigDecimal getMagnitude() {
        return this.magnitude;
    }

    public int compareTo(Interval rhs) {
        int baseUnit = this.unit;
        if (baseUnit > rhs.unit) {
            baseUnit = rhs.unit;
        }
        BigDecimal rhsMagnitude = rhs.getValueInUnits(baseUnit);
        BigDecimal lhsMagnitude = this.getValueInUnits(baseUnit);
        return lhsMagnitude.compareTo(rhsMagnitude);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Interval)) {
            return false;
        }
        Interval rhsInterval = (Interval)rhs;
        return this.magnitude.equals(rhsInterval.magnitude) && this.unit == rhsInterval.unit;
    }

    public int hashCode() {
        return this.magnitude.hashCode() + this.unit;
    }

    public Interval subtract(Interval rhs) {
        BigDecimal rhsMagnitude;
        BigDecimal lhsMagnitude;
        Interval result;
        BigDecimal lhsUnitMagnitude;
        int bigUnit = rhs.unit;
        int smallUnit = this.unit;
        if (bigUnit < smallUnit) {
            bigUnit = this.unit;
            smallUnit = rhs.unit;
        }
        if ((lhsUnitMagnitude = (result = new Interval((lhsMagnitude = this.getValueInUnits(smallUnit)).subtract(rhsMagnitude = rhs.getValueInUnits(smallUnit)), smallUnit)).getValueInUnits(this.unit)).abs().compareTo(POINT_FIVE) >= 0) {
            result = new Interval(lhsUnitMagnitude, this.unit);
        }
        return result;
    }

    public Interval add(Interval rhs) {
        int bigUnit = rhs.unit;
        int smallUnit = this.unit;
        if (bigUnit < smallUnit) {
            bigUnit = this.unit;
            smallUnit = rhs.unit;
        }
        BigDecimal lhsMagnitude = this.getValueInUnits(smallUnit);
        BigDecimal rhsMagnitude = rhs.getValueInUnits(smallUnit);
        Interval result = new Interval(lhsMagnitude.add(rhsMagnitude), smallUnit);
        BigDecimal lhsUnitMagnitude = result.getValueInUnits(this.unit);
        result = new Interval(lhsUnitMagnitude, this.unit);
        return result;
    }

    public int signum() {
        return this.magnitude.signum();
    }
}

