/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.ant;

import com.cenqua.clover.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public abstract class AbstractAntLogger
extends Logger {
    private static final int[] ANT_LOG_LEVELS = new int[]{0, 1, 2, 3, 4};
    protected Project proj;

    public AbstractAntLogger(Project aProj) {
        this.proj = aProj;
    }

    protected void antLog(Project proj, Task task, String aMsg, int antLogLevel) {
        if (task != null) {
            proj.log(task, aMsg, antLogLevel);
        }
    }

    public abstract Task getTask();

    protected int antLogLevel(int level) {
        return ANT_LOG_LEVELS[level];
    }

    public void log(int level, String aMsg, Throwable t) {
        if (t != null) {
            aMsg = aMsg + "\n" + t;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(stream));
            aMsg = aMsg + new String(stream.toByteArray());
        }
        this.antLog(this.proj, this.getTask(), aMsg, this.antLogLevel(level));
    }
}

