/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CoverageSnapshot;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.LivePerTestRecording;
import com.cenqua.clover.Logger;
import com.cenqua.clover.RuntimeType;
import com.cenqua.clover.util.CloverBitSet;
import com_cenqua_clover.CoverageRecorder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public interface PerTestRecorder {
    public static final int NO_EXIT_RESULT = -1;
    public static final int ABNORMAL_EXIT = 0;
    public static final int NORMAL_EXIT = 1;

    public void testStarted(String var1, long var2, int var4, int var5);

    public LivePerTestRecording testFinished(String var1, String var2, long var3, int var5, int var6, int var7, ErrorInfo var8);

    public void set(int var1);

    public static final class RecordingResult {
        public final LivePerTestRecording recording;
        public final Any recorders;

        public RecordingResult(LivePerTestRecording recording, Any recorders) {
            this.recording = recording;
            this.recorders = recorders;
        }
    }

    public static final class Many
    extends Any {
        private final One[] those;

        public Many(CoverageRecorder coverageRecorder, One[] those) {
            super(coverageRecorder);
            this.those = those;
        }

        public void set(int index) {
            for (int i = 0; i < this.those.length; ++i) {
                this.those[i].set(index);
            }
        }

        public Any testStarted(String type, long start, int slice, int testRunID) {
            One[] unaries = new One[this.those.length + 1];
            unaries[0] = new One(this.coverageRecorder, this.coverageRecorder.createEmptyHitsMask(), new RuntimeType(type), start, slice, testRunID);
            System.arraycopy(this.those, 0, unaries, 1, this.those.length);
            return new Many(this.coverageRecorder, unaries);
        }

        public RecordingResult testFinished(String type, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            RuntimeType runtimeType = new RuntimeType(type);
            if (this.those[0].matchesTest(type, slice, testRunId)) {
                if (this.those.length == 2) {
                    return new RecordingResult(new LivePerTestRecording.ToFile(this.coverageRecorder, this.those[0].coverage, method, this.those[0].start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), this.those[1]);
                }
                One[] unaries = new One[this.those.length - 1];
                System.arraycopy(this.those, 1, unaries, 0, this.those.length - 1);
                return new RecordingResult(new LivePerTestRecording.ToFile(this.coverageRecorder, this.those[0].coverage, method, this.those[0].start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), new Many(this.coverageRecorder, unaries));
            }
            Logger.getInstance().verbose("Test ending (" + One.asString(type, slice, testRunId) + ") " + "but test recorder in focus doesn't match: " + this.those[0]);
            One finished = null;
            ArrayList<One> singles = new ArrayList<One>(Arrays.asList(this.those));
            Iterator iterator = singles.iterator();
            while (iterator.hasNext()) {
                One one = (One)iterator.next();
                boolean matches = one.matchesTest(type, slice, testRunId);
                Logger.getInstance().verbose("Active recorder: " + one);
                if (!matches) continue;
                iterator.remove();
                finished = one;
            }
            if (finished == null) {
                Logger.getInstance().verbose("Test ending (" + One.asString(type, slice, testRunId) + ") " + "but no active per-test recorders match: " + this.toString());
                return new RecordingResult(LivePerTestRecording.NULL, this);
            }
            One[] singlesArray = singles.toArray(new One[singles.size()]);
            if (singles.size() == 1) {
                return new RecordingResult(new LivePerTestRecording.ToFile(this.coverageRecorder, finished.coverage, method, finished.start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), singlesArray[0]);
            }
            return new RecordingResult(new LivePerTestRecording.ToFile(this.coverageRecorder, finished.coverage, method, finished.start, end, runtimeType, slice, testRunId, exitStatus, errorInfo), new Many(this.coverageRecorder, singlesArray));
        }

        public String toString() {
            return "Many(" + this.those.length + "):PerTestRecorders[" + "those=" + Arrays.asList(this.those) + ']';
        }
    }

    public static final class One
    extends Any {
        protected final boolean[] coverageShortcut;
        protected final CloverBitSet coverage;
        protected final RuntimeType type;
        protected final long start;
        protected final int slice;
        protected final int testRunID;

        public One(CoverageRecorder coverageRecorder, CloverBitSet coverage, RuntimeType type, long start, int slice, int testRunID) {
            super(coverageRecorder);
            this.coverageShortcut = new boolean[coverage.size()];
            this.coverage = coverage;
            this.type = type;
            this.start = start;
            this.slice = slice;
            this.testRunID = testRunID;
        }

        public void set(int index) {
            if (!this.coverageShortcut[index]) {
                this.coverageShortcut[index] = true;
                this.coverage.add(index);
            }
        }

        public Any testStarted(String type, long start, int slice, int testRunID) {
            return new Many(this.coverageRecorder, new One[]{new One(this.coverageRecorder, this.coverageRecorder.createEmptyHitsMask(), new RuntimeType(type), start, slice, testRunID), this});
        }

        public RecordingResult testFinished(String type, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            if (!this.matchesTest(type, slice, testRunId)) {
                Logger.getInstance().verbose("Per-test recorder ending " + One.asString(type, slice, testRunId) + " " + "but different recorder in focus " + One.asString(this.type.name, this.slice, this.testRunID));
                return new RecordingResult(LivePerTestRecording.NULL, this);
            }
            return new RecordingResult(new LivePerTestRecording.ToFile(this.coverageRecorder, this.coverage, method, this.start, end, this.type, slice, testRunId, exitStatus, errorInfo), new None(this.coverageRecorder));
        }

        boolean matchesTest(String type, int slice, int testRunId) {
            return this.type.matches(type) && this.slice == slice && this.testRunID == testRunId;
        }

        public String toString() {
            return "One:PerTestRecorders[type=" + this.type + ", start=" + this.start + ", slice=" + this.slice + ", testRunID=" + this.testRunID + ']';
        }

        static String asString(String typeName, int slice, int testRunId) {
            return "[" + typeName + "," + slice + "," + testRunId + "]";
        }
    }

    public static final class None
    extends Any {
        public None(CoverageRecorder coverageRecorder) {
            super(coverageRecorder);
        }

        public void set(int index) {
        }

        public Any testStarted(String type, long start, int slice, int testRunID) {
            return new One(this.coverageRecorder, this.coverageRecorder.createEmptyHitsMask(), new RuntimeType(type), start, slice, testRunID);
        }

        public RecordingResult testFinished(String type, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            Logger.getInstance().verbose("Per-test recorder ending " + One.asString(type, slice, testRunId) + " but no current recorder in focus");
            return new RecordingResult(LivePerTestRecording.NULL, this);
        }
    }

    public static abstract class Any {
        protected final CoverageRecorder coverageRecorder;

        public Any(CoverageRecorder coverageRecorder) {
            this.coverageRecorder = coverageRecorder;
        }

        public abstract void set(int var1);

        public abstract Any testStarted(String var1, long var2, int var4, int var5);

        public abstract RecordingResult testFinished(String var1, String var2, long var3, int var5, int var6, int var7, ErrorInfo var8);
    }

    public static interface Holder
    extends PerTestRecorder {

        public static class SingleThreaded
        implements Holder {
            private Any recorders;

            public SingleThreaded(CoverageRecorder coverageRecorder) {
                this.recorders = new None(coverageRecorder);
            }

            public void testStarted(String runtimeType, long start, int slice, int testRunId) {
                this.recorders = this.recorders.testStarted(runtimeType, start, slice, testRunId);
            }

            public LivePerTestRecording testFinished(String runtimeType, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
                RecordingResult sliceAndRecorders = this.recorders.testFinished(runtimeType, method, end, slice, testRunId, exitStatus, ei);
                this.recorders = sliceAndRecorders.recorders;
                return sliceAndRecorders.recording;
            }

            public void set(int index) {
                this.recorders.set(index);
            }
        }

        public static class Synchronized
        implements Holder {
            private Any recorders;

            public Synchronized(CoverageRecorder coverageRecorder) {
                this.recorders = new None(coverageRecorder);
            }

            public synchronized void testStarted(String runtimeType, long start, int slice, int testRunId) {
                this.recorders = this.recorders.testStarted(runtimeType, start, slice, testRunId);
            }

            public synchronized LivePerTestRecording testFinished(String runtimeType, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
                RecordingResult sliceAndRecorders = this.recorders.testFinished(runtimeType, method, end, slice, testRunId, exitStatus, ei);
                this.recorders = sliceAndRecorders.recorders;
                return sliceAndRecorders.recording;
            }

            public synchronized void set(int index) {
                this.recorders.set(index);
            }
        }

        public static class Volatile
        implements Holder {
            private volatile Any recorders;

            public Volatile(CoverageRecorder coverageRecorder) {
                this.recorders = new None(coverageRecorder);
            }

            public synchronized void testStarted(String runtimeType, long start, int slice, int testRunId) {
                this.recorders = this.recorders.testStarted(runtimeType, start, slice, testRunId);
            }

            public synchronized LivePerTestRecording testFinished(String runtimeType, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
                RecordingResult sliceAndRecorders = this.recorders.testFinished(runtimeType, method, end, slice, testRunId, exitStatus, ei);
                this.recorders = sliceAndRecorders.recorders;
                return sliceAndRecorders.recording;
            }

            public void set(int index) {
                this.recorders.set(index);
            }
        }
    }

    public static class Diffing
    implements PerTestRecorder {
        protected final CoverageRecorder coverageRecorder;
        protected long start;
        protected CoverageSnapshot startingCoverage;

        public Diffing(CoverageRecorder coverageRecorder) {
            this.coverageRecorder = coverageRecorder;
        }

        public void set(int index) {
        }

        public void testStarted(String type, long start, int slice, int testRunID) {
            this.start = start;
            this.startingCoverage = this.coverageRecorder.getCoverageSnapshot();
        }

        public LivePerTestRecording testFinished(String type, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            return new LivePerTestRecording.ToFile(this.coverageRecorder, this.coverageRecorder.compareCoverageWith(this.startingCoverage), method, this.start, end, new RuntimeType(type), slice, testRunId, exitStatus, errorInfo);
        }

        private CloverBitSet diff(CloverBitSet start, CloverBitSet end) {
            end.subtractInPlace(start);
            return end;
        }
    }

    public static class Null
    implements PerTestRecorder {
        public void testStarted(String runtimeType, long start, int slice, int testRunId) {
        }

        public LivePerTestRecording testFinished(String runtimeType, String method, long end, int slice, int testRunId, int exitStatus, ErrorInfo ei) {
            return LivePerTestRecording.NULL;
        }

        public void set(int index) {
        }
    }
}

