/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.DefaultLogger;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class Logger {
    public static final int LOG_ERR = 0;
    public static final int LOG_WARN = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_VERBOSE = 3;
    public static final int LOG_DEBUG = 4;
    private static final Logger NULL_LOGGER = new NullLogger();
    private static Logger singleton = null;
    private static Factory factoryInstance = new Factory(){

        public Logger getLoggerInstance(String category) {
            return new DefaultLogger();
        }
    };
    private static boolean debug = false;
    private static boolean verbose = false;

    public static Logger getInstance(String category) {
        if (singleton != null) {
            return singleton;
        }
        return factoryInstance == null ? NULL_LOGGER : factoryInstance.getLoggerInstance(category);
    }

    public static Logger getInstance() {
        return Logger.getInstance("com.cenqua.clover.core_v3.0.2-build-790");
    }

    public static void setFactory(Factory factory) {
        factoryInstance = factory;
    }

    public static void setInstance(Logger instance) {
        singleton = instance;
    }

    public static void setDebug(boolean debug) {
        Logger.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean verbose) {
        Logger.verbose = verbose;
    }

    public static boolean canIgnore(int level) {
        if (!debug && level == 4) {
            return true;
        }
        return !verbose && !debug && level == 3;
    }

    public void error(String msg) {
        this.log(0, msg, null);
    }

    public void error(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public void error(Throwable t) {
        this.log(0, t != null ? t.getMessage() : "Exception", t);
    }

    public void warn(String msg) {
        this.log(1, msg, null);
    }

    public void warn(String msg, Throwable t) {
        this.log(1, msg, t);
    }

    public void warn(Throwable t) {
        this.log(1, t != null ? t.getMessage() : "Exception", t);
    }

    public void info(String msg) {
        this.log(2, msg, null);
    }

    public void info(String msg, Throwable t) {
        this.log(2, msg, t);
    }

    public void info(Throwable t) {
        this.log(2, t != null ? t.getMessage() : "Exception", t);
    }

    public void verbose(String msg) {
        this.log(3, msg, null);
    }

    public void verbose(String msg, Throwable t) {
        this.log(3, msg, t);
    }

    public void verbose(Throwable t) {
        this.log(3, t != null ? t.getMessage() : "Exception", t);
    }

    public void debug(String msg) {
        this.log(4, msg, null);
    }

    public void debug(String msg, Throwable t) {
        this.log(4, msg, t);
    }

    public void debug(Throwable t) {
        this.log(4, t != null ? t.getMessage() : "Exception", t);
    }

    protected Logger() {
    }

    public abstract void log(int var1, String var2, Throwable var3);

    static {
        try {
            String level = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("clover.logging.level");
                }

                @Override
                public /* synthetic */ Object run() {
                    return this.run();
                }
            });
            if ("debug".equalsIgnoreCase(level)) {
                Logger.setDebug(true);
            } else if ("verbose".equalsIgnoreCase(level)) {
                Logger.setVerbose(true);
            }
        }
        catch (SecurityException e) {
            System.err.println("Security exception trying to initialise Clover logging: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static class NullLogger
    extends Logger {
        public void log(int level, String msg, Throwable t) {
        }
    }

    public static interface Factory {
        public Logger getLoggerInstance(String var1);
    }
}

