/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class FOSFactory {
    private static final boolean USE_SYNCHRONOUS_IO;
    static final Class[] REQUIRED_CLASSES;
    static /* synthetic */ Class class$com$cenqua$clover$FOSFactory$SyncingFileOutputStream;

    public static FileOutputStream newFOS(File file) throws FileNotFoundException {
        if (USE_SYNCHRONOUS_IO) {
            return new SyncingFileOutputStream(file);
        }
        return new FileOutputStream(file);
    }

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$com$cenqua$clover$FOSFactory$SyncingFileOutputStream;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$FOSFactory$SyncingFileOutputStream = new SyncingFileOutputStream[0].getClass().getComponentType();
        }
        classArray[0] = clazz;
        REQUIRED_CLASSES = classArray;
        Boolean useSyncIO = Boolean.FALSE;
        try {
            useSyncIO = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return new Boolean(System.getProperty("clover.synchronous.io"));
                }

                @Override
                public /* synthetic */ Object run() {
                    return this.run();
                }
            });
        }
        catch (SecurityException e) {
            Logger.getInstance().info("Unable to determine Clover IO mode", e);
        }
        USE_SYNCHRONOUS_IO = useSyncIO != null ? useSyncIO : false;
    }

    private static class SyncingFileOutputStream
    extends FileOutputStream {
        private SyncingFileOutputStream(File name) throws FileNotFoundException {
            super(name);
        }

        public void flush() throws IOException {
            super.flush();
            this.getFD().sync();
        }
    }
}

