/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.org.apache.commons.lang.mutable.MutableLong;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.CoverageRecordingTranscript;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestRecordingTranscript;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.RecordingTranscripts;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.collections.Pair;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageDataCollator {
    private Clover2Registry registry;
    private RecordingTranscripts.Filter filter;

    public CoverageDataCollator(Clover2Registry registry) {
        this.registry = registry;
    }

    public CoverageDataCollator(Clover2Registry registry, CoverageDataSpec spec) {
        this.registry = registry;
        this.filter = new RecordingTranscripts.Filter(FileUtils.getCurrentDirIfNull(registry.getRegistryFile().getParentFile()), registry.getRegistryFile().getName(), registry.getVersion() - spec.getSpan(), Long.MAX_VALUE, spec.isDeleteUnusedCoverage(), spec.isLoadPerTestData());
    }

    public CoverageDataCollator copyWithNewRegistry(Clover2Registry registry) {
        CoverageDataCollator collator = new CoverageDataCollator(registry);
        collator.filter = this.filter;
        return collator;
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        return this.loadCoverageData(null, spec, progressListener);
    }

    public CoverageData loadCoverageData(CoverageData coverageData, CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        RecordingTranscripts.Filter prevFilter = this.filter;
        RecordingTranscripts.Filter newFilter = this.updateFilter(prevFilter, spec);
        if (newFilter == prevFilter && coverageData != null) {
            coverageData = new CoverageData(this.registry, coverageData, spec);
            Pair<Set<RecordingTranscripts.FileRef>, Set<RecordingTranscripts.FileRef>> newRecordings = newFilter.collectUnseenFilesAnd(prevFilter);
            this.collateRecordingFiles((Collection)newRecordings.first, coverageData, spec);
            if (spec.isLoadPerTestData()) {
                this.collatePerTestRecordings((Collection)newRecordings.second, coverageData, spec, progressListener != null ? progressListener : ProgressListener.NOOP_LISTENER);
            }
        } else {
            newFilter.collectAllFiles();
            coverageData = new CoverageData(this.registry, spec);
            this.collateRecordingFiles(newFilter.getCoverageRecordingFiles(), coverageData, spec);
            if (spec.isLoadPerTestData()) {
                this.collatePerTestRecordings(newFilter.getPerTestRecordingFiles(), coverageData, spec, progressListener != null ? progressListener : ProgressListener.NOOP_LISTENER);
            }
        }
        this.filter = newFilter;
        return coverageData;
    }

    public boolean isOutOfDate() {
        return this.filter == null || this.filter.isOutOfDate();
    }

    private RecordingTranscripts.Filter updateFilter(RecordingTranscripts.Filter prevFilter, CoverageDataSpec spec) {
        long from = this.registry.getVersion() - spec.getSpan();
        long to = Long.MAX_VALUE;
        boolean loadPerTestData = spec.isLoadPerTestData();
        return prevFilter == null || prevFilter.getFrom() != from || prevFilter.getTo() != Long.MAX_VALUE || prevFilter.isLoadPerTestData() != loadPerTestData ? new RecordingTranscripts.Filter(FileUtils.getCurrentDirIfNull(this.registry.getRegistryFile().getParentFile()), this.registry.getRegistryFile().getName(), from, Long.MAX_VALUE, spec.isDeleteUnusedCoverage(), loadPerTestData) : prevFilter;
    }

    private void collateRecordingFiles(Collection<RecordingTranscripts.FileRef> files, CoverageData coverageData, CoverageDataSpec spec) {
        long start = System.currentTimeMillis();
        int numRecordings = 0;
        long tsNewestRecordingUsed = 0L;
        long tsOldestRecordingUsed = Long.MAX_VALUE;
        final MutableLong maxVersion = new MutableLong(0L);
        final MutableLong minVersion = new MutableLong(Long.MAX_VALUE);
        this.registry.getProject().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo f) {
                FileInfo file = (FileInfo)f;
                maxVersion.setValue(Math.max(maxVersion.longValue(), file.getMaxVersion()));
                minVersion.setValue(Math.min(minVersion.longValue(), file.getMinVersion()));
            }
        });
        Iterator<RecordingTranscripts.FileRef> it = files.iterator();
        while (it.hasNext()) {
            boolean[] alreadyTruncated = new boolean[]{false};
            RecordingTranscripts.FileRef recordingFile = it.next();
            try {
                CoverageRecordingTranscript rec = (CoverageRecordingTranscript)recordingFile.read(spec);
                long version = rec.getDbVersion();
                if (version <= maxVersion.longValue() && version >= minVersion.longValue()) {
                    coverageData.addCoverage(rec);
                    ++numRecordings;
                    if (recordingFile.getTimestamp() < tsOldestRecordingUsed) {
                        tsOldestRecordingUsed = recordingFile.getTimestamp();
                    }
                    if (rec.getWriteTimeStamp() <= tsNewestRecordingUsed) continue;
                    tsNewestRecordingUsed = rec.getWriteTimeStamp();
                    continue;
                }
                Logger.getInstance().debug(new StringBuffer().append("Ignoring coverage recording ").append(rec).append(" because no FileInfo supports its coverage range").toString());
            }
            catch (IOException e) {
                Logger.getInstance().warn(new StringBuffer().append("Failed to load coverage recording ").append(recordingFile).toString(), e);
            }
        }
        coverageData.avoidObviousOverflow();
        coverageData.setTimestamp(tsNewestRecordingUsed);
        long end = System.currentTimeMillis();
        Logger.getInstance().debug(new StringBuffer().append("Processed ").append(numRecordings).append(" recording files in ").append(end - start).append("ms (").append(numRecordings != 0 ? new StringBuffer().append("").append((end - start) / (long)numRecordings).append("ms").toString() : "-").append(" per recording)").toString());
    }

    private void collatePerTestRecordings(Collection<RecordingTranscripts.FileRef> perTestRecordings, CoverageData coverageData, CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        long start = System.currentTimeMillis();
        int numPerTestRecordings = 0;
        float progress = 0.0f;
        float progressIncrement = perTestRecordings.size() > 0 ? 1.0f / (float)perTestRecordings.size() : 1.0f;
        Iterator<RecordingTranscripts.FileRef> it = perTestRecordings.iterator();
        while (it.hasNext()) {
            ++numPerTestRecordings;
            RecordingTranscripts.FileRef recordingFile = it.next();
            try {
                PerTestRecordingTranscript recording = (PerTestRecordingTranscript)recordingFile.read(spec);
                TestCaseInfo tci = TestCaseInfo.Factory.getInstanceForSlice(recording);
                coverageData.addCoverage(tci, recording);
            }
            catch (Exception e) {
                Logger.getInstance().verbose(new StringBuffer().append("Failed to load per-test coverage recording ").append(recordingFile).toString(), e);
            }
            progressListener.handleProgress("Reading per-test data", progress += progressIncrement);
        }
        long end = System.currentTimeMillis();
        Logger.getInstance().debug(new StringBuffer().append("Processed ").append(numPerTestRecordings).append(" per-test recording files in ").append(end - start).append("ms (").append(numPerTestRecordings != 0 ? new StringBuffer().append("").append((end - start) / (long)numPerTestRecordings).append("ms").toString() : "-").append(" per recording)").toString());
    }
}

