/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedIO;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.io.tags.Tags;
import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.format.BufferUtils;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.LazyLoader;
import com.atlassian.clover.registry.format.LazyProxy;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.StatementRegexpContext;
import com.cenqua.clover.registry.Annotation;
import com.cenqua.clover.registry.ArrayAnnotationValue;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.Modifiers;
import com.cenqua.clover.registry.Parameter;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.StringifiedAnnotationValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrSessionSegment {
    static final long NONE_IDX = -1L;
    static final Tags TAGS;
    private final long version;
    private final long startTs;
    private final long endTs;
    private final List<FileInfoRecord> fileInfoRecords;
    private final LazyProxy<ContextStore> ctxStore;
    static /* synthetic */ Class class$com$cenqua$clover$registry$BranchInfo;
    static /* synthetic */ Class class$com$cenqua$clover$registry$Parameter;
    static /* synthetic */ Class class$com$cenqua$clover$context$ContextStore;
    static /* synthetic */ Class class$com$cenqua$clover$context$StatementRegexpContext;
    static /* synthetic */ Class class$com$cenqua$clover$registry$Modifiers;
    static /* synthetic */ Class class$com$cenqua$clover$registry$MethodInfo;
    static /* synthetic */ Class class$com$cenqua$clover$registry$StatementInfo;
    static /* synthetic */ Class class$com$cenqua$clover$context$ContextSet;
    static /* synthetic */ Class class$com$cenqua$clover$context$MethodRegexpContext;
    static /* synthetic */ Class class$com$cenqua$clover$registry$ClassInfo;
    static /* synthetic */ Class class$com$cenqua$clover$registry$FileInfo;
    static /* synthetic */ Class class$com$cenqua$clover$registry$MethodSignature;
    static /* synthetic */ Class class$com$cenqua$clover$registry$StringifiedAnnotationValue;
    static /* synthetic */ Class class$com$cenqua$clover$registry$Annotation;
    static /* synthetic */ Class class$com$cenqua$clover$registry$FixedSourceRegion;
    static /* synthetic */ Class class$com$cenqua$clover$registry$ArrayAnnotationValue;

    public InstrSessionSegment(FileChannel channel) throws IOException {
        long endOfSegment = channel.position();
        Footer footer = this.loadFooter(channel, endOfSegment);
        this.version = footer.version;
        this.startTs = footer.startTs;
        this.endTs = footer.endTs;
        this.ctxStore = new LazyLoader<ContextStore>(channel, endOfSegment - 40L - (long)footer.ctxStoreByteLen + 1L){

            @Override
            protected ContextStore getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return InstrSessionSegment.this.loadContextStore(channel);
            }

            @Override
            protected /* synthetic */ Object getImpl(FileChannel x0) throws IOException, RegistryFormatException {
                return this.getImpl(x0);
            }
        };
        this.fileInfoRecords = this.loadFileInfos(channel, endOfSegment, footer.fileInfosByteLen, footer.ctxStoreByteLen, footer.numRecords);
        channel.position(Math.max(0L, endOfSegment - 40L - (long)footer.fileInfosByteLen - (long)footer.ctxStoreByteLen));
    }

    public InstrSessionSegment(long version, long startTs, long endTs, List<FileInfoRecord> fileInfoRecords, ContextStore ctxStore) {
        this.version = version;
        this.startTs = startTs;
        this.endTs = endTs;
        this.fileInfoRecords = Collections.unmodifiableList(new LinkedList<FileInfoRecord>(fileInfoRecords));
        this.ctxStore = new LazyProxy.Preloaded<ContextStore>(ctxStore);
    }

    private Footer loadFooter(FileChannel channel, long endOfSegment) throws IOException {
        channel.position(endOfSegment - 40L + 1L);
        ByteBuffer footerBuffer = BufferUtils.readFully(channel, ByteBuffer.allocate(40));
        Footer footer = new Footer(footerBuffer.getInt(), footerBuffer.getInt(), footerBuffer.getInt(), footerBuffer.getLong(), footerBuffer.getLong(), footerBuffer.getLong());
        Logger.getInstance().debug(new StringBuffer().append("Loaded InstrumentationSession footer: ").append(footer).toString());
        if (footerBuffer.getInt() != 56026) {
            throw new IOException(new StringBuffer().append("InstrSessionSegment did not start with marker 0x").append(Integer.toHexString(56026)).toString());
        }
        return footer;
    }

    private List<FileInfoRecord> loadFileInfos(FileChannel channel, long endOfSegment, int fileInfosByteLen, int offset, int numRecords) throws IOException {
        long startRecPos = endOfSegment - 40L - (long)offset - (long)fileInfosByteLen + 1L;
        Logger.getInstance().debug(new StringBuffer().append("Loading InstrumentationSession: Loading FileInfos: setting channel position to ").append(startRecPos).append(" out of ").append(channel.size()).toString());
        channel.position(startRecPos);
        LinkedList<FileInfoRecord> fileInfos = new LinkedList<FileInfoRecord>();
        for (int i = 0; i < numRecords; ++i) {
            fileInfos.add(new FileInfoRecord(channel));
        }
        return Collections.unmodifiableList(fileInfos);
    }

    private ContextStore loadContextStore(FileChannel channel) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$context$ContextStore;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$context$ContextStore = new ContextStore[0].getClass().getComponentType();
        }
        return (ContextStore)TaggedIO.read(channel, TAGS, clazz);
    }

    public Collection<FileInfoRecord> getFileInfoRecords() {
        return this.fileInfoRecords;
    }

    public long getVersion() {
        return this.version;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public long getEndTs() {
        return this.endTs;
    }

    public ContextStore getCtxStore() {
        return this.ctxStore.get();
    }

    public void write(FileChannel channel) throws IOException {
        long startPos = channel.position();
        for (FileInfoRecord fileInfo : this.fileInfoRecords) {
            fileInfo.write(channel);
        }
        long afterFileInfosPos = channel.position();
        Class<?> clazz = class$com$cenqua$clover$context$ContextStore;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$context$ContextStore = new ContextStore[0].getClass().getComponentType();
        }
        TaggedIO.write(channel, TAGS, clazz, (TaggedPersistent)this.ctxStore.get());
        long afterCtxStorePos = channel.position();
        ByteBuffer headerBuffer = ByteBuffer.allocate(40);
        headerBuffer.putInt((int)(afterFileInfosPos - startPos));
        headerBuffer.putInt((int)(afterCtxStorePos - afterFileInfosPos));
        headerBuffer.putInt(this.fileInfoRecords.size());
        headerBuffer.putLong(this.endTs);
        headerBuffer.putLong(this.startTs);
        headerBuffer.putLong(this.version);
        headerBuffer.putInt(56026);
        headerBuffer.flip();
        BufferUtils.writeFully(channel, headerBuffer);
    }

    static {
        Tags tags = new Tags();
        Class<?> clazz = class$com$cenqua$clover$registry$FileInfo;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$registry$FileInfo = new FileInfo[0].getClass().getComponentType();
        }
        Tags tags2 = tags.registerTag(clazz.getName(), 9, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FileInfo>(){

            @Override
            public FileInfo read(TaggedDataInput in) throws IOException {
                return FileInfo.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz2 = class$com$cenqua$clover$registry$ClassInfo;
        if (clazz2 == null) {
            clazz2 = class$com$cenqua$clover$registry$ClassInfo = new ClassInfo[0].getClass().getComponentType();
        }
        Tags tags3 = tags2.registerTag(clazz2.getName(), 10, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ClassInfo>(){

            @Override
            public ClassInfo read(TaggedDataInput in) throws IOException {
                return ClassInfo.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz3 = class$com$cenqua$clover$registry$MethodInfo;
        if (clazz3 == null) {
            clazz3 = class$com$cenqua$clover$registry$MethodInfo = new MethodInfo[0].getClass().getComponentType();
        }
        Tags tags4 = tags3.registerTag(clazz3.getName(), 11, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<MethodInfo>(){

            @Override
            public MethodInfo read(TaggedDataInput in) throws IOException {
                return MethodInfo.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz4 = class$com$cenqua$clover$registry$StatementInfo;
        if (clazz4 == null) {
            clazz4 = class$com$cenqua$clover$registry$StatementInfo = new StatementInfo[0].getClass().getComponentType();
        }
        Tags tags5 = tags4.registerTag(clazz4.getName(), 12, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<StatementInfo>(){

            @Override
            public StatementInfo read(TaggedDataInput in) throws IOException {
                return StatementInfo.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz5 = class$com$cenqua$clover$registry$BranchInfo;
        if (clazz5 == null) {
            clazz5 = class$com$cenqua$clover$registry$BranchInfo = new BranchInfo[0].getClass().getComponentType();
        }
        Tags tags6 = tags5.registerTag(clazz5.getName(), 13, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<BranchInfo>(){

            @Override
            public BranchInfo read(TaggedDataInput in) throws IOException {
                return BranchInfo.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz6 = class$com$cenqua$clover$context$ContextSet;
        if (clazz6 == null) {
            clazz6 = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        Tags tags7 = tags6.registerTag(clazz6.getName(), 14, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ContextSet>(){

            @Override
            public ContextSet read(TaggedDataInput in) throws IOException {
                return ContextSet.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz7 = class$com$cenqua$clover$registry$FixedSourceRegion;
        if (clazz7 == null) {
            clazz7 = class$com$cenqua$clover$registry$FixedSourceRegion = new FixedSourceRegion[0].getClass().getComponentType();
        }
        Tags tags8 = tags7.registerTag(clazz7.getName(), 15, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<FixedSourceRegion>(){

            @Override
            public FixedSourceRegion read(TaggedDataInput in) throws IOException {
                return FixedSourceRegion.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz8 = class$com$cenqua$clover$registry$MethodSignature;
        if (clazz8 == null) {
            clazz8 = class$com$cenqua$clover$registry$MethodSignature = new MethodSignature[0].getClass().getComponentType();
        }
        Tags tags9 = tags8.registerTag(clazz8.getName(), 16, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<MethodSignature>(){

            @Override
            public MethodSignature read(TaggedDataInput in) throws IOException {
                return MethodSignature.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz9 = class$com$cenqua$clover$registry$Modifiers;
        if (clazz9 == null) {
            clazz9 = class$com$cenqua$clover$registry$Modifiers = new Modifiers[0].getClass().getComponentType();
        }
        Tags tags10 = tags9.registerTag(clazz9.getName(), 17, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<Modifiers>(){

            @Override
            public Modifiers read(TaggedDataInput in) throws IOException {
                return Modifiers.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz10 = class$com$cenqua$clover$registry$Parameter;
        if (clazz10 == null) {
            clazz10 = class$com$cenqua$clover$registry$Parameter = new Parameter[0].getClass().getComponentType();
        }
        Tags tags11 = tags10.registerTag(clazz10.getName(), 18, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<Parameter>(){

            @Override
            public Parameter read(TaggedDataInput in) throws IOException {
                return Parameter.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz11 = class$com$cenqua$clover$registry$Annotation;
        if (clazz11 == null) {
            clazz11 = class$com$cenqua$clover$registry$Annotation = new Annotation[0].getClass().getComponentType();
        }
        Tags tags12 = tags11.registerTag(clazz11.getName(), 19, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<Annotation>(){

            @Override
            public Annotation read(TaggedDataInput in) throws IOException {
                return Annotation.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz12 = class$com$cenqua$clover$registry$ArrayAnnotationValue;
        if (clazz12 == null) {
            clazz12 = class$com$cenqua$clover$registry$ArrayAnnotationValue = new ArrayAnnotationValue[0].getClass().getComponentType();
        }
        Tags tags13 = tags12.registerTag(clazz12.getName(), 20, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ArrayAnnotationValue>(){

            @Override
            public ArrayAnnotationValue read(TaggedDataInput in) throws IOException {
                return ArrayAnnotationValue.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz13 = class$com$cenqua$clover$registry$StringifiedAnnotationValue;
        if (clazz13 == null) {
            clazz13 = class$com$cenqua$clover$registry$StringifiedAnnotationValue = new StringifiedAnnotationValue[0].getClass().getComponentType();
        }
        Tags tags14 = tags13.registerTag(clazz13.getName(), 21, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<StringifiedAnnotationValue>(){

            @Override
            public StringifiedAnnotationValue read(TaggedDataInput in) throws IOException {
                return StringifiedAnnotationValue.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz14 = class$com$cenqua$clover$context$ContextStore;
        if (clazz14 == null) {
            clazz14 = class$com$cenqua$clover$context$ContextStore = new ContextStore[0].getClass().getComponentType();
        }
        Tags tags15 = tags14.registerTag(clazz14.getName(), 22, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<ContextStore>(){

            @Override
            public ContextStore read(TaggedDataInput in) throws IOException {
                return ContextStore.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz15 = class$com$cenqua$clover$context$StatementRegexpContext;
        if (clazz15 == null) {
            clazz15 = class$com$cenqua$clover$context$StatementRegexpContext = new StatementRegexpContext[0].getClass().getComponentType();
        }
        Tags tags16 = tags15.registerTag(clazz15.getName(), 23, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<StatementRegexpContext>(){

            @Override
            public StatementRegexpContext read(TaggedDataInput in) throws IOException {
                return StatementRegexpContext.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
        Class<?> clazz16 = class$com$cenqua$clover$context$MethodRegexpContext;
        if (clazz16 == null) {
            clazz16 = class$com$cenqua$clover$context$MethodRegexpContext = new MethodRegexpContext[0].getClass().getComponentType();
        }
        TAGS = tags16.registerTag(clazz16.getName(), 24, (Tags.ObjectReader<? extends TaggedPersistent>)new Tags.ObjectReader<MethodRegexpContext>(){

            @Override
            public MethodRegexpContext read(TaggedDataInput in) throws IOException {
                return MethodRegexpContext.read(in);
            }

            @Override
            public /* synthetic */ TaggedPersistent read(TaggedDataInput x0) throws IOException {
                return this.read(x0);
            }
        });
    }

    private static class Footer {
        public static final int SIZE = 40;
        public static final int MARKER = 56026;
        public final int fileInfosByteLen;
        public final int ctxStoreByteLen;
        public final int numRecords;
        public final long endTs;
        public final long startTs;
        public final long version;

        private Footer(int fileInfosByteLen, int ctxStoreByteLen, int numRecords, long endTs, long startTs, long version) {
            this.fileInfosByteLen = fileInfosByteLen;
            this.ctxStoreByteLen = ctxStoreByteLen;
            this.numRecords = numRecords;
            this.endTs = endTs;
            this.startTs = startTs;
            this.version = version;
        }

        public String toString() {
            return "Footer{fileInfosByteLen=" + this.fileInfosByteLen + ", ctxStoreByteLen=" + this.ctxStoreByteLen + ", numRecords=" + this.numRecords + ", endTs=" + this.endTs + ", startTs=" + this.startTs + ", version=" + this.version + '}';
        }
    }
}

