/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.AggregateTestDetector;
import com.atlassian.clover.instr.tests.OrStrategy;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.instr.tests.TestSourceMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileMappedTestDetector
implements TestDetector {
    private List testFileMatchers = new ArrayList();
    private TestDetector defaultDetector = null;

    public FileMappedTestDetector() {
    }

    public FileMappedTestDetector(TestDetector defaultDetector) {
        this.defaultDetector = defaultDetector;
    }

    public void addTestSourceMatcher(TestSourceMatcher matcher) {
        this.testFileMatchers.add(matcher);
    }

    public TestDetector getDetectorForFile(File f) {
        AggregateTestDetector detectors = new AggregateTestDetector(new OrStrategy());
        Iterator matchers = this.testFileMatchers.iterator();
        while (matchers.hasNext()) {
            TestSourceMatcher matcher = (TestSourceMatcher)matchers.next();
            if (!matcher.matchesFile(f)) continue;
            detectors.addDetector(matcher.getDetector());
        }
        return detectors.isEmpty() ? this.defaultDetector : detectors;
    }

    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        TestDetector t = this.getDetectorForFile(sourceContext.getSourceFile());
        return t != null && t.isTypeMatch(sourceContext, typeContext);
    }

    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        TestDetector t = this.getDetectorForFile(sourceContext.getSourceFile());
        return t != null && t.isMethodMatch(sourceContext, methodContext);
    }
}

