/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import cloverantlr.CommonHiddenStreamToken;
import com.atlassian.clover.instr.java.CloverToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenListUtil {
    private static final Pattern ML_PATTERN = Pattern.compile("\r\n|\r|\n");
    private static final Pattern MATCH_JAVADOC_LINE = Pattern.compile("^\\s*(?:/\\*\\*)?(?:\\*)*(?!/)(.*?)(?:\\**/)?$");
    private static final Pattern MATCH_JAVADOC_TAG_LINE_START = Pattern.compile("^\\s*@(\\S+)(:?\\s+(.*))?$");
    private static final Set<String> IGNORED_TAGS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("deprecated");
            this.add("param");
            this.add("throws");
            this.add("see");
            this.add("serialField");
            this.add("serialData");
            this.add("author");
            this.add("since");
            this.add("version");
            this.add("exception");
        }
    });

    public static String getNormalisedSequence(CloverToken begin, CloverToken end) {
        return TokenListUtil.getNormalisedSequence(begin, end, true);
    }

    public static String getNormalisedSequence(CloverToken begin, CloverToken end, boolean whitespace) {
        StringBuffer buf = new StringBuffer();
        CloverToken prev = null;
        for (CloverToken curr = begin; curr != null; curr = curr.getNext()) {
            if (prev != null && TokenListUtil.hasWhitespaceAfter(prev) && whitespace) {
                buf.append(" ");
            }
            buf.append(curr.getText());
            if (curr == end) break;
            prev = curr;
        }
        return buf.toString();
    }

    public static boolean hasWhitespaceAfter(CloverToken token) {
        for (CommonHiddenStreamToken curr = token.getHiddenAfter(); curr != null; curr = curr.getHiddenAfter()) {
            if (curr.getType() != 147) continue;
            return true;
        }
        return false;
    }

    public static Map getJDocTagsAndValuesOnBlock(CloverToken startOfField) {
        CloverToken prev = startOfField.getPrev();
        HashMap tags = new HashMap();
        for (CommonHiddenStreamToken hidden = prev != null ? prev.getHiddenAfter() : startOfField.getFilter().getInitialHiddenToken(); hidden != null; hidden = hidden.getHiddenAfter()) {
            if (149 != hidden.getType() || !hidden.getText().startsWith("/**")) continue;
            TokenListUtil.getJDocTagsOnComment(tags, hidden.getText());
        }
        return tags;
    }

    public static void getJDocTagsOnComment(Map tags, String comment) {
        String[] lines = ML_PATTERN.split(comment);
        boolean inTag = false;
        String tagName = null;
        String tagContents = "";
        for (int i = 0; i < lines.length; ++i) {
            Matcher lineMatcher = MATCH_JAVADOC_LINE.matcher(lines[i]);
            if (!lineMatcher.matches()) continue;
            String lineContents = lineMatcher.group(1);
            Matcher tagMatcher = MATCH_JAVADOC_TAG_LINE_START.matcher(lineContents);
            if (tagMatcher.matches()) {
                if (!inTag) {
                    inTag = true;
                } else if (!TokenListUtil.ignore(tagName)) {
                    TokenListUtil.addTag(tags, tagName, tagContents.trim());
                }
                tagName = tagMatcher.group(1);
                tagContents = TokenListUtil.emptyStringForNull(tagMatcher.group(2));
                continue;
            }
            if (!inTag) continue;
            tagContents = tagContents + lineContents;
        }
        if (tagName != null && !TokenListUtil.ignore(tagName)) {
            TokenListUtil.addTag(tags, tagName, tagContents.trim());
        }
    }

    private static boolean ignore(String tagName) {
        return IGNORED_TAGS.contains(tagName);
    }

    private static String emptyStringForNull(String string) {
        return string == null ? "" : string;
    }

    private static void addTag(Map tags, String tagName, String tagContents) {
        LinkedList<String> tagValues = (LinkedList<String>)tags.get(tagName);
        if (tagValues == null) {
            tagValues = new LinkedList<String>();
            tags.put(tagName, tagValues);
        }
        tagValues.add(tagContents);
    }
}

