/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.CloverToken;
import java.util.BitSet;

public class ExpressionInfo {
    private boolean constant = false;
    private boolean containsAssign = false;
    private int complexity = 0;
    private static final BitSet CONSTANT_TOKENS = new BitSet();

    public static ExpressionInfo fromTokens(CloverToken start, CloverToken end) {
        ExpressionInfo info = new ExpressionInfo();
        info.constant = true;
        CloverToken t = start;
        while (t.getNext() != end.getNext()) {
            if (!CONSTANT_TOKENS.get(t.getType())) {
                info.constant = false;
                break;
            }
            t = t.getNext();
        }
        if (!info.constant) {
            info.complexity = 1;
            int openParens = 1;
            block7: for (CloverToken curr = start; curr != null && openParens > 0 && curr != end; curr = curr.getNext()) {
                switch (curr.getType()) {
                    case 89: {
                        info.containsAssign = true;
                        continue block7;
                    }
                    case 84: {
                        ++openParens;
                        continue block7;
                    }
                    case 85: {
                        --openParens;
                        continue block7;
                    }
                    case 119: 
                    case 120: {
                        ++info.complexity;
                        continue block7;
                    }
                }
            }
        }
        return info;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public boolean isContainsAssign() {
        return this.containsAssign;
    }

    public boolean isInstrumentable() {
        return !this.constant && !this.containsAssign;
    }

    public int getComplexity() {
        return this.complexity;
    }

    static {
        CONSTANT_TOKENS.set(137);
        CONSTANT_TOKENS.set(138);
        CONSTANT_TOKENS.set(139);
        CONSTANT_TOKENS.set(141);
        CONSTANT_TOKENS.set(144);
        CONSTANT_TOKENS.set(145);
        CONSTANT_TOKENS.set(146);
        CONSTANT_TOKENS.set(142);
        CONSTANT_TOKENS.set(143);
        CONSTANT_TOKENS.set(129);
        CONSTANT_TOKENS.set(130);
        CONSTANT_TOKENS.set(131);
        CONSTANT_TOKENS.set(132);
        CONSTANT_TOKENS.set(69);
        CONSTANT_TOKENS.set(123);
        CONSTANT_TOKENS.set(124);
        CONSTANT_TOKENS.set(136);
        CONSTANT_TOKENS.set(119);
        CONSTANT_TOKENS.set(120);
        CONSTANT_TOKENS.set(121);
        CONSTANT_TOKENS.set(81);
        CONSTANT_TOKENS.set(135);
        CONSTANT_TOKENS.set(122);
        CONSTANT_TOKENS.set(84);
        CONSTANT_TOKENS.set(85);
        CONSTANT_TOKENS.set(54);
        CONSTANT_TOKENS.set(93);
        CONSTANT_TOKENS.set(53);
        CONSTANT_TOKENS.set(57);
        CONSTANT_TOKENS.set(52);
        CONSTANT_TOKENS.set(126);
        CONSTANT_TOKENS.set(125);
        CONSTANT_TOKENS.set(128);
        CONSTANT_TOKENS.set(58);
        CONSTANT_TOKENS.set(59);
    }
}

