/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.api.optimization;

import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.test.optimization.ClassOptimizable;
import com.cenqua.clover.test.optimization.LocalSnapshotOptimizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOptimizer {
    private final OptimizationOptions options;

    public TestOptimizer(OptimizationOptions options) {
        this.options = options;
    }

    public TestOptimizer(String initString, File snapshotFile) {
        this.options = new OptimizationOptions.Builder().debug(true).initString(initString).snapshot(snapshotFile).build();
    }

    public Collection<Class> optimizeTestClasses(Collection<Class> testClasses) {
        List<Optimizable> optimizableClasses = this.convertClassesToOptimizables(testClasses);
        List<Optimizable> optimizedClasses = this.optimize(optimizableClasses);
        return this.convertClassList(optimizedClasses);
    }

    public List<Optimizable> optimize(List<Optimizable> optimizables) {
        try {
            return LocalSnapshotOptimizer.optimize(optimizables, this.options);
        }
        catch (CloverException e) {
            Logger.getInstance().error("Optimization failed. Running all specified tests.");
            Logger.getInstance().debug(e.getMessage(), e);
            return optimizables;
        }
    }

    private Collection<Class> convertClassList(List<? extends Optimizable> optimizables) {
        ArrayList<Class> optimizedClasses = new ArrayList<Class>(optimizables.size());
        for (Optimizable optimizable : optimizables) {
            ClassOptimizable optClass = (ClassOptimizable)optimizable;
            optimizedClasses.add(optClass.getMyClass());
        }
        return optimizedClasses;
    }

    private List<Optimizable> convertClassesToOptimizables(Collection<Class> testClasses) {
        ArrayList<Optimizable> optimizables = new ArrayList<Optimizable>(testClasses.size());
        for (Class aClass : testClasses) {
            optimizables.add(new ClassOptimizable(aClass));
        }
        return optimizables;
    }
}

