/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.Contract;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntInstrUtils {
    public static String getProp(Project project, String key, String defaultValue) {
        Contract.pre(key != null);
        String prop = project.getProperty(key);
        if (prop == null) {
            prop = defaultValue;
        }
        return prop;
    }

    public static PatternSet calcInstrPatternSet(Project project) {
        AntInstrumentationConfig config;
        String includes = AntInstrUtils.getProp(project, "clover.includes", "");
        String excludes = AntInstrUtils.getProp(project, "clover.excludes", "");
        PatternSet instrPatternSet = null;
        if (includes.length() > 0 || excludes.length() > 0) {
            instrPatternSet = new PatternSet();
            if (includes.length() > 0) {
                instrPatternSet.setIncludes(includes);
            } else {
                instrPatternSet.setIncludes("**");
            }
            if (excludes.length() > 0) {
                instrPatternSet.setExcludes(excludes);
            }
        }
        if ((config = AntInstrumentationConfig.getFrom(project)) != null && config.getInstrPattern() != null) {
            if (instrPatternSet != null) {
                Logger.getInstance().warn("Sub-element <files> of <clover-setup> overrides clover.includes/excludes properties.");
            }
            instrPatternSet = config.getInstrPattern();
        }
        return instrPatternSet;
    }

    public static List<FileSet> calcInstrFileSets(Project project) {
        AntInstrumentationConfig config = AntInstrumentationConfig.getFrom(project);
        return config != null ? config.getInstrFilesets() : null;
    }

    public static File createInstrDir(File basedir) throws CloverException {
        File tmpDir;
        try {
            if (basedir != null) {
                if (!basedir.isDirectory() && !basedir.mkdirs()) {
                    throw new CloverException(new StringBuffer().append("Failed to create temp directory '").append(basedir).append("'").toString());
                }
                tmpDir = File.createTempFile("clover", null, basedir);
            } else {
                tmpDir = File.createTempFile("clover", null);
            }
            tmpDir.delete();
            if (!tmpDir.mkdirs() && !tmpDir.isDirectory()) {
                throw new CloverException("Failed to create temp directory");
            }
        }
        catch (IOException e) {
            throw new CloverException("Failed to create temp directory");
        }
        return tmpDir;
    }

    public static void cleanUpInstrDir(File tmpDir, boolean preserveInstr) {
        if (!preserveInstr && tmpDir != null) {
            FileUtils.deltree(tmpDir);
        }
    }

    public static void sieveSourceForInstrumentation(Project project, Path srcPath, PatternSet instrPatternSet, List<FileSet> instrFileSetsList, Collection<File> toCompile, Collection<File> toCopy, Collection<File> toInstrument) {
        if (instrFileSetsList == null && instrPatternSet == null) {
            Logger.getInstance().verbose("No <files/> nor <fileset/> elements found in <clover-setup/> - instrumenting all source found.");
            toCopy.clear();
            toInstrument.addAll(toCompile);
        } else if (instrPatternSet != null) {
            Logger.getInstance().verbose(new StringBuffer().append("<files/> element found in <clover-setup/> - filtering source found in").append(Arrays.asList(srcPath.list())).toString());
            String[] srcDirs = srcPath.list();
            for (int i = 0; i < srcDirs.length; ++i) {
                AntInstrUtils.sieveSrcPath(project, instrPatternSet, toCompile, toCopy, toInstrument, srcDirs[i]);
            }
        } else {
            Logger.getInstance().verbose("<fileset/> element(s) found in <clover-setup/>");
            for (FileSet fileSet : instrFileSetsList) {
                DirectoryScanner ds = fileSet.getDirectoryScanner(project);
                File baseDir = fileSet.getDir(project);
                Logger.getInstance().verbose(new StringBuffer().append("Filtering source files found in ").append(baseDir.getAbsolutePath()).toString());
                String[] included = ds.getIncludedFiles();
                if (included.length > 0) {
                    for (int j = 0; j < included.length; ++j) {
                        File inc = new File(baseDir, included[j]);
                        Logger.getInstance().verbose(new StringBuffer().append("Found file for instrumentation: ").append(inc.getAbsolutePath()).toString());
                        if (toCompile.contains(inc)) {
                            toInstrument.add(inc);
                            toCopy.remove(inc);
                        } else {
                            Logger.getInstance().verbose(new StringBuffer().append("File ").append(inc.getAbsolutePath()).append(" not in original compile list - ignoring").toString());
                        }
                        toCompile.remove(inc);
                    }
                } else {
                    Logger.getInstance().verbose("No sources found");
                }
                String[] excluded = ds.getExcludedFiles();
                if (excluded.length > 0) {
                    for (int j = 0; j < excluded.length; ++j) {
                        File exc = new File(baseDir, excluded[j]);
                        Logger.getInstance().verbose(new StringBuffer().append("Found file to exclude from instrumentation: ").append(exc.getAbsolutePath()).toString());
                        if (toCompile.contains(exc)) {
                            toInstrument.remove(exc);
                            toCopy.add(exc);
                        } else {
                            Logger.getInstance().verbose(new StringBuffer().append("File ").append(exc.getAbsolutePath()).append(" not in original compile list - ignoring").toString());
                        }
                        toCompile.remove(exc);
                    }
                    continue;
                }
                Logger.getInstance().verbose("No sources found");
            }
            if (toCompile.size() > 0) {
                Logger.getInstance().verbose(new StringBuffer().append(toCompile.size()).append(" file(s) in the compile list were neither included or excluded for Clover instrumentation. Adding to the exclude list:").toString());
                for (File file : toCompile) {
                    Logger.getInstance().verbose(file.getAbsolutePath());
                }
                toCopy.addAll(toCompile);
            }
        }
    }

    public static void sieveSrcPath(Project project, PatternSet instrPatternSet, Collection<File> toCompile, Collection<File> toCopy, Collection<File> toInstrument, String srcDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(srcDir);
        ds.setIncludes(instrPatternSet.getIncludePatterns(project));
        ds.setExcludes(instrPatternSet.getExcludePatterns(project));
        ds.scan();
        String[] included = ds.getIncludedFiles();
        for (int j = 0; j < included.length; ++j) {
            File inc = new File(srcDir, included[j]);
            if (!toCompile.contains(inc)) continue;
            toInstrument.add(inc);
            toCopy.remove(inc);
        }
        String[] excluded = ds.getExcludedFiles();
        for (int j = 0; j < excluded.length; ++j) {
            File exc = new File(srcDir, excluded[j]);
            if (!toCompile.contains(exc)) continue;
            toInstrument.remove(exc);
            toCopy.add(exc);
        }
    }
}

