/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.FieldNamingStrategy;
import clover.com.google.gson.MemoryRefStack;
import clover.com.google.gson.NullExclusionStrategy;
import clover.com.google.gson.ObjectNavigator;
import clover.com.google.gson.Preconditions;

final class ObjectNavigatorFactory {
    private final ExclusionStrategy strategy;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final MemoryRefStack<Object> stack;

    public ObjectNavigatorFactory(ExclusionStrategy strategy, FieldNamingStrategy fieldNamingPolicy) {
        Preconditions.checkNotNull(fieldNamingPolicy);
        this.strategy = strategy == null ? new NullExclusionStrategy() : strategy;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.stack = new MemoryRefStack();
    }

    public ObjectNavigator create(Object srcObject, Object type) {
        return new ObjectNavigator(srcObject, type, this.strategy, this.stack);
    }

    FieldNamingStrategy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }
}

