/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonNull;
import clover.com.google.gson.JsonPrimitive;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Appendable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonObject
extends JsonElement {
    private final Map<String, JsonElement> members = new LinkedHashMap<String, JsonElement>();

    public void add(String property, JsonElement value) {
        this.members.put(property, value);
    }

    public JsonElement remove(String property) {
        return this.members.remove(property);
    }

    public void addProperty(String property, String value) {
        this.add(property, this.createJsonElement(value));
    }

    public void addProperty(String property, Number value) {
        this.add(property, this.createJsonElement(value));
    }

    public void addProperty(String property, Boolean value) {
        this.add(property, this.createJsonElement(value));
    }

    public void addProperty(String property, Character value) {
        this.add(property, this.createJsonElement(value));
    }

    private JsonElement createJsonElement(Object value) {
        if (value == null) {
            return JsonNull.createJsonNull();
        }
        return new JsonPrimitive(value);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public boolean has(String memberName) {
        return this.members.containsKey(memberName);
    }

    public JsonElement get(String memberName) {
        if (this.members.containsKey(memberName)) {
            JsonElement member = this.members.get(memberName);
            return member == null ? JsonNull.createJsonNull() : member;
        }
        return null;
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get(memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get(memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return (JsonObject)this.members.get(memberName);
    }

    @Override
    protected void toString(Object sb) throws IOException {
        _Appendable.append(sb, '{');
        boolean first = true;
        for (Map.Entry<String, JsonElement> entry : this.members.entrySet()) {
            if (first) {
                first = false;
            } else {
                _Appendable.append(sb, ',');
            }
            _Appendable.append(sb, '\"');
            _Appendable.append(sb, entry.getKey());
            _Appendable.append(sb, "\":");
            entry.getValue().toString(sb);
        }
        _Appendable.append(sb, '}');
    }
}

