/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonElementVisitor;
import clover.com.google.gson.JsonEscapingVisitor;
import clover.com.google.gson.JsonFormatter;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonPrimitive;
import clover.com.google.gson.JsonTreeNavigator;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Appendable;
import java.io.IOException;

final class JsonCompactFormatter
implements JsonFormatter {
    private final boolean escapeHtmlChars;

    JsonCompactFormatter() {
        this(true);
    }

    JsonCompactFormatter(boolean escapeHtmlChars) {
        this.escapeHtmlChars = escapeHtmlChars;
    }

    public void format(JsonElement root, Object writer, boolean serializeNulls) throws IOException {
        if (root == null) {
            return;
        }
        JsonEscapingVisitor visitor = new JsonEscapingVisitor((JsonElementVisitor)new FormattingVisitor(writer, serializeNulls), this.escapeHtmlChars);
        JsonTreeNavigator navigator = new JsonTreeNavigator(visitor, serializeNulls);
        navigator.navigate(root);
    }

    private static class FormattingVisitor
    implements JsonElementVisitor {
        private final Object writer;
        private final boolean serializeNulls;

        FormattingVisitor(Object writer, boolean serializeNulls) {
            this.writer = writer;
            this.serializeNulls = serializeNulls;
        }

        public void visitPrimitive(JsonPrimitive primitive) throws IOException {
            primitive.toString(this.writer);
        }

        public void visitNull() throws IOException {
            _Appendable.append(this.writer, "null");
        }

        public void startArray(JsonArray array) throws IOException {
            _Appendable.append(this.writer, '[');
        }

        public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
            member.toString(this.writer);
        }

        public void visitArrayMember(JsonArray parent, JsonArray member, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
        }

        public void visitArrayMember(JsonArray parent, JsonObject member, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
        }

        public void visitNullArrayMember(JsonArray parent, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
        }

        public void endArray(JsonArray array) throws IOException {
            _Appendable.append(this.writer, ']');
        }

        public void startObject(JsonObject object) throws IOException {
            _Appendable.append(this.writer, '{');
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
            _Appendable.append(this.writer, '\"');
            _Appendable.append(this.writer, memberName);
            _Appendable.append(this.writer, "\":");
            member.toString(this.writer);
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
            _Appendable.append(this.writer, '\"');
            _Appendable.append(this.writer, memberName);
            _Appendable.append(this.writer, "\":");
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) throws IOException {
            if (!isFirst) {
                _Appendable.append(this.writer, ',');
            }
            _Appendable.append(this.writer, '\"');
            _Appendable.append(this.writer, memberName);
            _Appendable.append(this.writer, "\":");
        }

        public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) throws IOException {
            if (this.serializeNulls) {
                this.visitObjectMember(parent, memberName, (JsonObject)null, isFirst);
            }
        }

        public void endObject(JsonObject object) throws IOException {
            _Appendable.append(this.writer, '}');
        }
    }
}

