/*
 * Decompiled with CFR 0.152.
 */
package clover.com.atlassian.extras.core.bamboo;

import clover.com.atlassian.extras.api.Product;
import clover.com.atlassian.extras.api.ProductLicense;
import clover.com.atlassian.extras.common.LicenseException;
import clover.com.atlassian.extras.common.util.LicenseProperties;
import clover.com.atlassian.extras.core.AbstractProductLicenseFactory;
import clover.com.atlassian.extras.core.bamboo.DefaultBambooLicense;
import clover.com.atlassian.extras.core.transformer.DelegatingLicensePropertiesTransformer;
import clover.com.atlassian.extras.core.transformer.LicenseEditionPropertyTransformer;
import clover.com.atlassian.extras.core.transformer.LicensePropertiesTransformer;
import clover.com.atlassian.extras.core.transformer.Version1LicenseTypeTransformer;
import java.util.Arrays;

public class BambooProductLicenseFactory
extends AbstractProductLicenseFactory {
    private final LicensePropertiesTransformer transformer = new DelegatingLicensePropertiesTransformer(Arrays.asList(new Version1LicenseTypeTransformer(), new LicenseEditionPropertyTransformer()));

    protected LicensePropertiesTransformer getTransformer() {
        return this.transformer;
    }

    public ProductLicense getLicenseInternal(Product product, LicenseProperties licenseProperties) {
        if (Product.BAMBOO.equals(product)) {
            return new DefaultBambooLicense(product, licenseProperties);
        }
        throw new LicenseException("Could not create license for " + product);
    }
}

