/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.GenericTypeComparator;
import org.apache.flink.api.java.typeutils.runtime.KryoSerializer;

public class GenericTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private final Class<T> typeClass;

    public GenericTypeInfo(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public TypeSerializer<T> createSerializer() {
        return new KryoSerializer<T>(this.typeClass);
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending) {
        if (this.isKeyType()) {
            GenericTypeComparator<T> comparator = new GenericTypeComparator<T>(sortOrderAscending, this.createSerializer(), this.typeClass);
            return comparator;
        }
        throw new UnsupportedOperationException("Types that do not implement java.lang.Comparable cannot be used as keys.");
    }

    public int hashCode() {
        return this.typeClass.hashCode() ^ 0x165667B1;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == GenericTypeInfo.class) {
            return this.typeClass == ((GenericTypeInfo)((Object)obj)).typeClass;
        }
        return false;
    }

    public String toString() {
        return "GenericType<" + this.typeClass.getCanonicalName() + ">";
    }
}

