/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.configuration.Configuration;

public abstract class SingleInputUdfOperator<IN, OUT, O extends SingleInputUdfOperator<IN, OUT, O>>
extends SingleInputOperator<IN, OUT, O>
implements UdfOperator<O> {
    private Configuration parameters;
    private Map<String, DataSet<?>> broadcastVariables;
    private SingleInputSemanticProperties udfSemantics;

    protected SingleInputUdfOperator(DataSet<IN> input, TypeInformation<OUT> resultType) {
        super(input, resultType);
    }

    protected void extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
        Set<Annotation> annotations = FunctionAnnotation.readSingleConstantAnnotations(udfClass);
        SingleInputSemanticProperties sp = SemanticPropUtil.getSemanticPropsSingle(annotations, this.getInputType(), this.getResultType());
        this.setSemanticProperties(sp);
    }

    @Override
    public O withParameters(Configuration parameters) {
        this.parameters = parameters;
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public O withBroadcastSet(DataSet<?> data, String name) {
        if (data == null) {
            throw new IllegalArgumentException("Broadcast variable data must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Broadcast variable name must not be null.");
        }
        if (this.broadcastVariables == null) {
            this.broadcastVariables = new HashMap();
        }
        this.broadcastVariables.put(name, data);
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withConstantSet(String ... constantSet) {
        SingleInputSemanticProperties props = SemanticPropUtil.getSemanticPropsSingleFromString(constantSet, null, null, this.getInputType(), this.getResultType());
        this.setSemanticProperties(props);
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public Map<String, DataSet<?>> getBroadcastSets() {
        return this.broadcastVariables == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.broadcastVariables);
    }

    @Override
    public Configuration getParameters() {
        return this.parameters;
    }

    public SingleInputSemanticProperties getSemanticProperties() {
        return this.udfSemantics;
    }

    public void setSemanticProperties(SingleInputSemanticProperties properties) {
        this.udfSemantics = properties;
    }
}

