/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.spargel.java.record;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.record.functions.CoGroupFunction;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.operators.CoGroupOperator;
import org.apache.flink.api.java.record.operators.DeltaIteration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.spargel.java.record.MessageIterator;
import org.apache.flink.spargel.java.record.MessagingFunction;
import org.apache.flink.spargel.java.record.VertexUpdateFunction;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.ReflectionUtil;

public class SpargelIteration {
    private static final String DEFAULT_NAME = "<unnamed vertex-centric iteration>";
    private final DeltaIteration iteration;
    private final Class<? extends Key<?>> vertexKey;
    private final Class<? extends Value> vertexValue;
    private final Class<? extends Value> messageType;
    private final Class<? extends Value> edgeValue;
    private final CoGroupOperator vertexUpdater;
    private final CoGroupOperator messager;

    public <VertexKey extends Key<VertexKey>, VertexValue extends Value, Message extends Value, EdgeValue extends Value> SpargelIteration(MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> mf, VertexUpdateFunction<VertexKey, VertexValue, Message> uf) {
        this(mf, uf, DEFAULT_NAME);
    }

    public <VertexKey extends Key<VertexKey>, VertexValue extends Value, Message extends Value, EdgeValue extends Value> SpargelIteration(MessagingFunction<VertexKey, VertexValue, Message, EdgeValue> mf, VertexUpdateFunction<VertexKey, VertexValue, Message> uf, String name) {
        this.vertexKey = ReflectionUtil.getTemplateType1(mf.getClass());
        this.vertexValue = ReflectionUtil.getTemplateType2(mf.getClass());
        this.messageType = ReflectionUtil.getTemplateType3(mf.getClass());
        this.edgeValue = ReflectionUtil.getTemplateType4(mf.getClass());
        if (this.vertexKey == null || this.vertexValue == null || this.messageType == null || this.edgeValue == null) {
            throw new RuntimeException();
        }
        this.iteration = new DeltaIteration(0, name);
        this.messager = CoGroupOperator.builder(MessagingDriver.class, this.vertexKey, (int)0, (int)0).input2(this.iteration.getWorkset()).name("Message Sender").build();
        this.vertexUpdater = CoGroupOperator.builder(VertexUpdateDriver.class, this.vertexKey, (int)0, (int)0).input1((Operator)this.messager).input2(this.iteration.getSolutionSet()).name("Vertex Updater").build();
        this.iteration.setNextWorkset((Operator)this.vertexUpdater);
        this.iteration.setSolutionSetDelta((Operator)this.vertexUpdater);
        try {
            Configuration vertexUdfParams = this.vertexUpdater.getParameters();
            InstantiationUtil.writeObjectToConfig(uf, (Configuration)vertexUdfParams, (String)"spargel.udf");
            vertexUdfParams.setClass("spargel.key-type", this.vertexKey);
            vertexUdfParams.setClass("spargel.value-type", this.vertexValue);
            vertexUdfParams.setClass("spargel.message-type", this.messageType);
            Configuration messageUdfParams = this.messager.getParameters();
            InstantiationUtil.writeObjectToConfig(mf, (Configuration)messageUdfParams, (String)"spargel.udf");
            messageUdfParams.setClass("spargel.key-type", this.vertexKey);
            messageUdfParams.setClass("spargel.value-type", this.vertexValue);
            messageUdfParams.setClass("spargel.message-type", this.messageType);
            messageUdfParams.setClass("spargel.edge-value", this.edgeValue);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize the UDFs for distribution" + (e.getMessage() == null ? Character.valueOf('.') : ": " + e.getMessage()), e);
        }
    }

    public void setVertexInput(Operator<Record> c) {
        this.iteration.setInitialSolutionSet(c);
        this.iteration.setInitialWorkset(c);
    }

    public void setEdgesInput(Operator<Record> c) {
        this.messager.setFirstInput(c);
    }

    public Operator<?> getOutput() {
        return this.iteration;
    }

    public void setDegreeOfParallelism(int dop) {
        this.iteration.setDegreeOfParallelism(dop);
    }

    public void setNumberOfIterations(int iterations) {
        this.iteration.setMaximumNumberOfIterations(iterations);
    }

    public AggregatorRegistry getAggregators() {
        return this.iteration.getAggregators();
    }

    public static final class MessagingDriver<K extends Key<K>, V extends Value, M extends Value, E extends Value>
    extends CoGroupFunction {
        private static final long serialVersionUID = 1L;
        private static final String UDF_PARAM = "spargel.udf";
        private static final String KEY_PARAM = "spargel.key-type";
        private static final String VALUE_PARAM = "spargel.value-type";
        private static final String MESSAGE_PARAM = "spargel.message-type";
        private static final String EDGE_PARAM = "spargel.edge-value";
        private MessagingFunction<K, V, M, E> messagingFunction;
        private K vertexKey;
        private V vertexValue;

        public void coGroup(Iterator<Record> edges, Iterator<Record> state, Collector<Record> out) throws Exception {
            if (state.hasNext()) {
                Record first = state.next();
                first.getFieldInto(0, this.vertexKey);
                first.getFieldInto(1, this.vertexValue);
                this.messagingFunction.set(edges, out);
                this.messagingFunction.sendMessages(this.vertexKey, this.vertexValue);
            }
        }

        public void open(Configuration parameters) throws Exception {
            if (this.messagingFunction == null) {
                ClassLoader cl = this.getRuntimeContext().getUserCodeClassLoader();
                Class vertexKeyClass = parameters.getClass(KEY_PARAM, null, cl);
                Class vertexValueClass = parameters.getClass(VALUE_PARAM, null, cl);
                Class edgeClass = parameters.getClass(EDGE_PARAM, null, cl);
                this.vertexKey = (Key)InstantiationUtil.instantiate((Class)vertexKeyClass, Key.class);
                this.vertexValue = (Value)InstantiationUtil.instantiate((Class)vertexValueClass, Value.class);
                Key edgeKeyHolder = (Key)InstantiationUtil.instantiate((Class)vertexKeyClass, Key.class);
                Value edgeValueHolder = (Value)InstantiationUtil.instantiate((Class)edgeClass, Value.class);
                ClassLoader ucl = this.getRuntimeContext().getUserCodeClassLoader();
                try {
                    this.messagingFunction = (MessagingFunction)InstantiationUtil.readObjectFromConfig((Configuration)parameters, (String)UDF_PARAM, (ClassLoader)ucl);
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? "." : ": " + e.getMessage();
                    throw new Exception("Could not instantiate MessagingFunction" + message, e);
                }
                this.messagingFunction.init(this.getIterationRuntimeContext(), edgeKeyHolder, edgeValueHolder);
                this.messagingFunction.setup(parameters);
            }
            this.messagingFunction.preSuperstep();
        }

        public void close() throws Exception {
            this.messagingFunction.postSuperstep();
        }
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={0})
    public static final class VertexUpdateDriver<K extends Key<K>, V extends Value, M extends Value>
    extends CoGroupFunction {
        private static final long serialVersionUID = 1L;
        private static final String UDF_PARAM = "spargel.udf";
        private static final String KEY_PARAM = "spargel.key-type";
        private static final String VALUE_PARAM = "spargel.value-type";
        private static final String MESSAGE_PARAM = "spargel.message-type";
        private VertexUpdateFunction<K, V, M> vertexUpdateFunction;
        private K vertexKey;
        private V vertexValue;
        private MessageIterator<M> messageIter;

        public void coGroup(Iterator<Record> messages, Iterator<Record> vertex, Collector<Record> out) throws Exception {
            if (!vertex.hasNext()) {
                if (messages.hasNext()) {
                    String message = "Target vertex does not exist!.";
                    try {
                        Record next = messages.next();
                        next.getFieldInto(0, this.vertexKey);
                        message = "Target vertex '" + this.vertexKey + "' does not exist!.";
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw new Exception(message);
                }
                throw new Exception();
            }
            Record first = vertex.next();
            first.getFieldInto(0, this.vertexKey);
            first.getFieldInto(1, this.vertexValue);
            this.messageIter.setSource(messages);
            this.vertexUpdateFunction.setOutput(first, out);
            this.vertexUpdateFunction.updateVertex(this.vertexKey, this.vertexValue, this.messageIter);
        }

        public void open(Configuration parameters) throws Exception {
            if (this.vertexUpdateFunction == null) {
                ClassLoader cl = this.getRuntimeContext().getUserCodeClassLoader();
                Class vertexKeyClass = parameters.getClass(KEY_PARAM, null, cl);
                Class vertexValueClass = parameters.getClass(VALUE_PARAM, null, cl);
                Class messageClass = parameters.getClass(MESSAGE_PARAM, null, cl);
                this.vertexKey = (Key)InstantiationUtil.instantiate((Class)vertexKeyClass, Key.class);
                this.vertexValue = (Value)InstantiationUtil.instantiate((Class)vertexValueClass, Value.class);
                this.messageIter = new MessageIterator<Value>((Value)InstantiationUtil.instantiate((Class)messageClass, Value.class));
                ClassLoader ucl = this.getRuntimeContext().getUserCodeClassLoader();
                try {
                    this.vertexUpdateFunction = (VertexUpdateFunction)InstantiationUtil.readObjectFromConfig((Configuration)parameters, (String)UDF_PARAM, (ClassLoader)ucl);
                }
                catch (Exception e) {
                    String message = e.getMessage() == null ? "." : ": " + e.getMessage();
                    throw new Exception("Could not instantiate VertexUpdateFunction" + message, e);
                }
                this.vertexUpdateFunction.init(this.getIterationRuntimeContext());
                this.vertexUpdateFunction.setup(parameters);
            }
            this.vertexUpdateFunction.preSuperstep();
        }

        public void close() throws Exception {
            this.vertexUpdateFunction.postSuperstep();
        }
    }
}

