/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.spargel.java.examples;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.spargel.java.MessageIterator;
import org.apache.flink.spargel.java.MessagingFunction;
import org.apache.flink.spargel.java.OutgoingEdge;
import org.apache.flink.spargel.java.VertexCentricIteration;
import org.apache.flink.spargel.java.VertexUpdateFunction;
import org.apache.flink.util.Collector;

public class SpargelPageRankCountingVertices {
    private static final double BETA = 0.85;

    public static void main(String[] args) throws Exception {
        int NUM_VERTICES = 100;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource vertices = env.generateSequence(1L, 100L);
        FlatMapOperator edgesWithProbability = env.generateSequence(1L, 100L).flatMap((FlatMapFunction)new FlatMapFunction<Long, Tuple3<Long, Long, Double>>(){

            public void flatMap(Long value, Collector<Tuple3<Long, Long, Double>> out) {
                int numOutEdges = (int)(Math.random() * 50.0);
                for (int i = 0; i < numOutEdges; ++i) {
                    long target = (long)(Math.random() * 100.0) + 1L;
                    out.collect((Object)new Tuple3((Object)value, (Object)target, (Object)(1.0 / (double)numOutEdges)));
                }
            }
        });
        ReduceOperator count = vertices.map((MapFunction)new MapFunction<Long, Long>(){

            public Long map(Long value) {
                return 1L;
            }
        }).reduce((ReduceFunction)new ReduceFunction<Long>(){

            public Long reduce(Long value1, Long value2) {
                return value1 + value2;
            }
        });
        SingleInputUdfOperator intialRanks = vertices.map((MapFunction)new RichMapFunction<Long, Tuple2<Long, Double>>(){
            private long numVertices;

            public void open(Configuration parameters) {
                this.numVertices = (Long)this.getRuntimeContext().getBroadcastVariable("count").iterator().next();
            }

            public Tuple2<Long, Double> map(Long value) {
                return new Tuple2((Object)value, (Object)(1.0 / (double)this.numVertices));
            }
        }).withBroadcastSet((DataSet)count, "count");
        VertexCentricIteration<Long, Double, Double, Double> iteration = VertexCentricIteration.withValuedEdges(edgesWithProbability, new VertexRankUpdater(0.85), new RankMessenger(), 20);
        iteration.addBroadcastSetForUpdateFunction("count", (DataSet<?>)count);
        DataSet result = intialRanks.runOperation(iteration);
        result.print();
        env.execute("Spargel PageRank");
    }

    public static final class RankMessenger
    extends MessagingFunction<Long, Double, Double, Double> {
        @Override
        public void sendMessages(Long vertexId, Double newRank) {
            for (OutgoingEdge edge : this.getOutgoingEdges()) {
                this.sendMessageTo(edge.target(), newRank * (Double)edge.edgeValue());
            }
        }
    }

    public static final class VertexRankUpdater
    extends VertexUpdateFunction<Long, Double, Double> {
        private final double beta;
        private long numVertices;

        public VertexRankUpdater(double beta) {
            this.beta = beta;
        }

        @Override
        public void preSuperstep() {
            this.numVertices = (Long)this.getBroadcastSet("count").iterator().next();
        }

        @Override
        public void updateVertex(Long vertexKey, Double vertexValue, MessageIterator<Double> inMessages) {
            double rankSum = 0.0;
            for (double msg : inMessages) {
                rankSum += msg;
            }
            double newRank = this.beta * rankSum + 0.15000000000000002 / (double)this.numVertices;
            this.setNewVertexValue(newRank);
        }
    }
}

