/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.spargel.java;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.spargel.java.MessageIterator;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public abstract class VertexUpdateFunction<VertexKey extends Comparable<VertexKey>, VertexValue, Message>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IterationRuntimeContext runtimeContext;
    private Collector<Tuple2<VertexKey, VertexValue>> out;
    private Tuple2<VertexKey, VertexValue> outVal;

    public abstract void updateVertex(VertexKey var1, VertexValue var2, MessageIterator<Message> var3) throws Exception;

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public void setNewVertexValue(VertexValue newValue) {
        this.outVal.f1 = newValue;
        this.out.collect(this.outVal);
    }

    public int getSuperstepNumber() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    public <T> Collection<T> getBroadcastSet(String name) {
        return this.runtimeContext.getBroadcastVariable(name);
    }

    void init(IterationRuntimeContext context) {
        this.runtimeContext = context;
    }

    void setOutput(Tuple2<VertexKey, VertexValue> val, Collector<Tuple2<VertexKey, VertexValue>> out) {
        this.out = out;
        this.outVal = val;
    }
}

