/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.spargel.java;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.spargel.java.OutgoingEdge;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public abstract class MessagingFunction<VertexKey extends Comparable<VertexKey>, VertexValue, Message, EdgeValue>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Tuple2<VertexKey, Message> outValue;
    private IterationRuntimeContext runtimeContext;
    private Iterator<?> edges;
    private Collector<Tuple2<VertexKey, Message>> out;
    private EdgesIteratorNoEdgeValue<VertexKey, EdgeValue> edgeNoValueIter;
    private EdgesIteratorWithEdgeValue<VertexKey, EdgeValue> edgeWithValueIter;
    private boolean edgesUsed;

    public abstract void sendMessages(VertexKey var1, VertexValue var2) throws Exception;

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public Iterable<OutgoingEdge<VertexKey, EdgeValue>> getOutgoingEdges() {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getOutgoingEdges()' or 'sendMessageToAllTargets()' exactly once.");
        }
        this.edgesUsed = true;
        if (this.edgeWithValueIter != null) {
            this.edgeWithValueIter.set(this.edges);
            return this.edgeWithValueIter;
        }
        this.edgeNoValueIter.set(this.edges);
        return this.edgeNoValueIter;
    }

    public void sendMessageToAllNeighbors(Message m) {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getOutgoingEdges()' or 'sendMessageToAllTargets()' exactly once.");
        }
        this.edgesUsed = true;
        this.outValue.f1 = m;
        while (this.edges.hasNext()) {
            Tuple next = (Tuple)this.edges.next();
            Comparable k = (Comparable)next.getField(1);
            this.outValue.f0 = k;
            this.out.collect(this.outValue);
        }
    }

    public void sendMessageTo(VertexKey target, Message m) {
        this.outValue.f0 = target;
        this.outValue.f1 = m;
        this.out.collect(this.outValue);
    }

    public int getSuperstepNumber() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    public <T> Collection<T> getBroadcastSet(String name) {
        return this.runtimeContext.getBroadcastVariable(name);
    }

    void init(IterationRuntimeContext context, boolean hasEdgeValue) {
        this.runtimeContext = context;
        this.outValue = new Tuple2();
        if (hasEdgeValue) {
            this.edgeWithValueIter = new EdgesIteratorWithEdgeValue();
        } else {
            this.edgeNoValueIter = new EdgesIteratorNoEdgeValue();
        }
    }

    void set(Iterator<?> edges, Collector<Tuple2<VertexKey, Message>> out) {
        this.edges = edges;
        this.out = out;
        this.edgesUsed = false;
    }

    private static final class EdgesIteratorWithEdgeValue<VertexKey extends Comparable<VertexKey>, EdgeValue>
    implements Iterator<OutgoingEdge<VertexKey, EdgeValue>>,
    Iterable<OutgoingEdge<VertexKey, EdgeValue>> {
        private Iterator<Tuple3<VertexKey, VertexKey, EdgeValue>> input;
        private OutgoingEdge<VertexKey, EdgeValue> edge = new OutgoingEdge();

        private EdgesIteratorWithEdgeValue() {
        }

        void set(Iterator<Tuple3<VertexKey, VertexKey, EdgeValue>> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public OutgoingEdge<VertexKey, EdgeValue> next() {
            Tuple3<VertexKey, VertexKey, EdgeValue> next = this.input.next();
            this.edge.set((Comparable)next.f1, next.f2);
            return this.edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<OutgoingEdge<VertexKey, EdgeValue>> iterator() {
            return this;
        }
    }

    private static final class EdgesIteratorNoEdgeValue<VertexKey extends Comparable<VertexKey>, EdgeValue>
    implements Iterator<OutgoingEdge<VertexKey, EdgeValue>>,
    Iterable<OutgoingEdge<VertexKey, EdgeValue>> {
        private Iterator<Tuple2<VertexKey, VertexKey>> input;
        private OutgoingEdge<VertexKey, EdgeValue> edge = new OutgoingEdge();

        private EdgesIteratorNoEdgeValue() {
        }

        void set(Iterator<Tuple2<VertexKey, VertexKey>> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public OutgoingEdge<VertexKey, EdgeValue> next() {
            Tuple2<VertexKey, VertexKey> next = this.input.next();
            this.edge.set((Comparable)next.f1, null);
            return this.edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<OutgoingEdge<VertexKey, EdgeValue>> iterator() {
            return this;
        }
    }
}

